/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMEStandard;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.mail.MimeException;

public class SignedEntity {
    static final long serialVersionUID = -519795569247486544L;
    private transient MimeEntity content;
    private transient MimeEntity signature;
    private transient MimeMultipart originalMMPart;

    public SignedEntity(ContentType mmContentType, MimeMultipart mm) throws MimeException {
        this.originalMMPart = mm;
        try {
            for (int i = 0; i < mm.getCount(); ++i) {
                String contentType = mm.getBodyPart(i).getContentType();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                mm.getBodyPart(i).writeTo((OutputStream)bos);
                bos.flush();
                ByteArrayInputStream stream = new ByteArrayInputStream(bos.toByteArray());
                MimeEntity ent = new MimeEntity(stream);
                IOUtils.closeQuietly((OutputStream)bos);
                if (contentType.contains("application/pkcs7-signature") || contentType.contains("application/x-pkcs7-signature")) {
                    this.signature = ent;
                    continue;
                }
                this.content = ent;
            }
        }
        catch (IOException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)e);
        }
        catch (MessagingException e) {
            throw new MimeException(MimeError.InvalidMimeEntity, (Exception)((Object)e));
        }
    }

    public SignedEntity(DigestAlgorithm algorithm, MimeMultipart mm) {
        this(SignedEntity.createContentType(algorithm), mm);
    }

    public MimeEntity getContent() {
        return this.content;
    }

    public void setContent(MimeEntity value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.content = value;
    }

    public MimeEntity getSignature() {
        return this.signature;
    }

    public void setSignature(MimeEntity value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.signature = value;
    }

    public MimeMultipart getMimeMultipart() {
        return this.originalMMPart;
    }

    public byte[] getEntityBodyAsBytes() {
        byte[] retVal = null;
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        try {
            this.originalMMPart.writeTo((OutputStream)oStream);
            retVal = oStream.toByteArray();
            IOUtils.closeQuietly((OutputStream)oStream);
        }
        catch (Exception e) {
            throw new MimeException(MimeError.InvalidMimeEntity, e);
        }
        return retVal;
    }

    public static SignedEntity load(MimeMultipart source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        SignedEntity retVal = null;
        try {
            retVal = new SignedEntity(new ContentType(source.getContentType()), source);
        }
        catch (ParseException e) {
            throw new MimeException(MimeError.InvalidHeader, (Exception)((Object)e));
        }
        return retVal;
    }

    static ContentType createContentType(DigestAlgorithm digestAlgorithm) {
        ContentType contentType = null;
        try {
            contentType = new ContentType("multipart/signed; protocol=\"application/x-pkcs7-signature\";");
            contentType.setParameter("micalg", SMIMEStandard.toString(digestAlgorithm));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return contentType;
    }
}

