/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.TrustModel;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessOutgoingMessage_Test
extends TestCase {
    public void testMessageIsWrapped_WrapMessageIsNotCalled() throws Exception {
        new TestPlan(){

            @Override
            protected OutgoingMessage createMessage() throws Exception {
                SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
                mimeMsg.setText("");
                Message msg = new Message(mimeMsg){

                    public String getContentType() throws MessagingException {
                        return "message/rfc822";
                    }
                };
                NHINDAddressCollection recipients = new NHINDAddressCollection();
                recipients.add((Object)new NHINDAddress(""));
                NHINDAddress sender = new NHINDAddress("");
                this.theCreateMessage = new OutgoingMessage(msg, recipients, sender){

                    protected void categorizeRecipients(TrustEnforcementStatus minTrustStatus) {
                        ++categorizeRecipientsCalls;
                        this.categorizeRecipients_Internal(minTrustStatus);
                    }
                };
                return this.theCreateMessage;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)0, (int)this.wrapMessageCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToBindAddressMethod() throws Exception {
        new TestPlan(){

            @Override
            protected void bindAddresses_Internal(OutgoingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.bindAddressesCalls);
            }
        }.perform();
    }

    public void testMessageDoesntHaveRecipients_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasRecipients_Internal() {
                this.theHasRecipients = false;
                return this.theHasRecipients;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agentException = (AgentException)((Object)exception);
                Assert.assertTrue((boolean)agentException.getError().equals(AgentError.MissingTo));
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToEnforce() throws Exception {
        new TestPlan(){

            @Override
            protected void enforce_Internal(OutgoingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.enforceCalls);
            }
        }.perform();
    }

    public void testMessageDoesntHaveTrustedRecipients_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasRecipients_Internal() {
                this.theHasRecipients = this.hasRecipientsCalls != 2;
                return this.theHasRecipients;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertEquals((int)2, (int)this.hasRecipientsCalls);
                Assert.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agentException = (AgentException)((Object)exception);
                Assert.assertTrue((boolean)agentException.getError().equals(AgentError.NoTrustedRecipients));
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToSignAndEncryptMessage() throws Exception {
        new TestPlan(){

            @Override
            protected void signAndEncryptMessage_Internal(OutgoingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.signAndEncryptMessageCalls);
            }
        }.perform();
    }

    public void testUpdateRoutingHeadersIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.updateRoutingHeadersCalls);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected Message theWrapMessage;
        protected int wrapMessageCalls = 0;
        protected int bindAddressesCalls = 0;
        protected int signAndEncryptMessageCalls = 0;
        protected OutgoingMessage theCreateMessage;
        protected int updateRoutingHeadersCalls = 0;
        protected TrustModel theCreateTrustModel;
        protected int enforceCalls = 0;
        protected int categorizeRecipientsCalls = 0;
        protected boolean theHasRecipients;
        protected int hasRecipientsCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createNHINDAgent();
            impl.processMessage(this.createMessage());
            this.doAssertions();
        }

        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver(), this.createTrustModel(), (Cryptographer)new SMIMECryptographerImpl()){

                protected void bindAddresses(OutgoingMessage message) {
                    ++TestPlan.this.bindAddressesCalls;
                    TestPlan.this.bindAddresses_Internal(message);
                }

                protected Message wrapMessage(Message message) {
                    ++TestPlan.this.wrapMessageCalls;
                    return TestPlan.this.wrapMessage_Internal(message);
                }

                protected void signAndEncryptMessage(OutgoingMessage message) {
                    ++TestPlan.this.signAndEncryptMessageCalls;
                    TestPlan.this.signAndEncryptMessage_Internal(message);
                }
            };
        }

        protected Message wrapMessage_Internal(Message message) {
            this.theWrapMessage = message;
            return this.theWrapMessage;
        }

        protected void bindAddresses_Internal(OutgoingMessage message) {
        }

        protected void signAndEncryptMessage_Internal(OutgoingMessage message) {
        }

        protected OutgoingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new OutgoingMessage(msg, recipients, sender){

                public boolean hasRecipients() {
                    ++TestPlan.this.hasRecipientsCalls;
                    return TestPlan.this.hasRecipients_Internal();
                }

                protected void categorizeRecipients(TrustEnforcementStatus minTrustStatus) {
                    ++TestPlan.this.categorizeRecipientsCalls;
                    TestPlan.this.categorizeRecipients_Internal(minTrustStatus);
                }

                protected void updateRoutingHeaders() {
                    ++TestPlan.this.updateRoutingHeadersCalls;
                    TestPlan.this.updateRoutingHeaders_Internal();
                }
            };
            return this.theCreateMessage;
        }

        protected void updateRoutingHeaders_Internal() {
        }

        protected void enforce_Internal(OutgoingMessage message) {
        }

        protected void categorizeRecipients_Internal(TrustEnforcementStatus minTrustStatus) {
        }

        protected boolean hasRecipients_Internal() {
            this.theHasRecipients = true;
            return this.theHasRecipients;
        }

        protected TrustModel createTrustModel() {
            this.theCreateTrustModel = new TrustModel(){

                public void enforce(OutgoingMessage message) {
                    ++TestPlan.this.enforceCalls;
                    TestPlan.this.enforce_Internal(message);
                }
            };
            return this.theCreateTrustModel;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

