/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import junit.framework.TestCase;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.SignatureValidationException;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.utils.TestUtils;

public class SMIMECryptographerImpl_checkSignature_Test
extends TestCase {
    private X509Certificate sigCertA;
    private X509Certificate sigCertAPrivate;
    private X509Certificate sigCertB;
    private X509Certificate sigCertBPrivate;
    private X509Certificate otherCert;
    private X509Certificate sigCertAnchor;
    private SignedEntity signedEntity;
    private SMIMECryptographerImpl cryptographer;

    public void setUp() throws Exception {
        CryptoExtensions.registerJCEProviders();
        this.sigCertA = TestUtils.loadCertificate("certCheckA.der");
        this.sigCertAPrivate = TestUtils.loadCertificate("certCheckA.p12");
        this.sigCertB = TestUtils.loadCertificate("certCheckB.der");
        this.sigCertBPrivate = TestUtils.loadCertificate("certCheckB.p12");
        this.sigCertAnchor = TestUtils.loadCertificate("Check Signature CA.der");
        this.otherCert = TestUtils.loadCertificate("gm2552.der");
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        this.cryptographer = new SMIMECryptographerImpl();
        this.cryptographer.setLogDigests(true);
        this.signedEntity = this.cryptographer.sign(new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())), this.sigCertAPrivate);
    }

    public void testValidateSig_sameSignAndValidationCert_assertValidSignature() throws Exception {
        this.cryptographer.checkSignature(this.signedEntity, this.sigCertA, Arrays.asList(this.sigCertAnchor));
    }

    public void testValidateSig_differentSignAndValidationCert_sameCA_assertInValidSignature() throws Exception {
        boolean exceptionOccured = false;
        try {
            this.cryptographer.checkSignature(this.signedEntity, this.sigCertB, Arrays.asList(this.sigCertAnchor));
        }
        catch (SignatureValidationException e) {
            exceptionOccured = true;
        }
        SMIMECryptographerImpl_checkSignature_Test.assertTrue((boolean)exceptionOccured);
    }

    public void testValidateSig_diffSignAndValidationCert_assertInvalidSignature() throws Exception {
        boolean exceptionOccured = false;
        try {
            this.cryptographer.checkSignature(this.signedEntity, this.otherCert, Arrays.asList(this.sigCertAnchor));
        }
        catch (SignatureValidationException e) {
            exceptionOccured = true;
        }
        SMIMECryptographerImpl_checkSignature_Test.assertTrue((boolean)exceptionOccured);
    }

    public void testMutlipleSigs_sameSignAndValidationCert_assertValidSignature() throws Exception {
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        this.cryptographer = new SMIMECryptographerImpl();
        this.cryptographer.setLogDigests(true);
        this.signedEntity = this.cryptographer.sign(new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())), Arrays.asList(this.sigCertAPrivate, this.sigCertBPrivate));
        this.cryptographer.checkSignature(this.signedEntity, this.sigCertA, Arrays.asList(this.sigCertAnchor));
        this.cryptographer.checkSignature(this.signedEntity, this.sigCertB, Arrays.asList(this.sigCertAnchor));
    }
}

