/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import java.util.Arrays;
import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager_setParamsTest
extends TestCase {
    public void setUp() {
        OptionsManager.INSTANCE = null;
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    public void testSetParams_emptyParams_setNonExistantParam() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamsTest.assertNull((Object)mgr.getParameter("Test Param"));
        OptionsManager_setParamsTest.assertEquals((int)0, (int)mgr.getParameters().size());
        OptionsParameter param1 = new OptionsParameter("Test Param1", "Test Value");
        OptionsParameter param2 = new OptionsParameter("Test Param2", "Test Value");
        mgr.setOptionsParameters(Arrays.asList(param1, param2));
        OptionsManager_setParamsTest.assertEquals((int)2, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("Test Param1");
        OptionsManager_setParamsTest.assertNotNull((Object)retParam);
        OptionsManager_setParamsTest.assertEquals((String)param1.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamsTest.assertEquals((String)param1.getParamValue(), (String)retParam.getParamValue());
    }

    public void testSetParams_overrideExistantParam() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamsTest.assertNull((Object)mgr.getParameter("Test Param"));
        OptionsParameter param = new OptionsParameter("Test Param", "Test Value");
        mgr.setOptionsParameters(Arrays.asList(param));
        OptionsManager_setParamsTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("Test Param");
        OptionsManager_setParamsTest.assertNotNull((Object)retParam);
        OptionsManager_setParamsTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamsTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        param = new OptionsParameter("Test Param", "Test Value2");
        mgr.setOptionsParameters(Arrays.asList(param));
        OptionsManager_setParamsTest.assertEquals((int)1, (int)mgr.getParameters().size());
        retParam = mgr.getParameter("Test Param");
        OptionsManager_setParamsTest.assertNotNull((Object)retParam);
        OptionsManager_setParamsTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamsTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
    }

    public void testSetParams_overrideJVMParam() throws Exception {
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "BC");
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamsTest.assertNotNull((Object)"JCE_PROVIDER");
        OptionsParameter param = new OptionsParameter("JCE_PROVIDER", "NSS");
        mgr.setOptionsParameters(Arrays.asList(param));
        OptionsManager_setParamsTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("JCE_PROVIDER");
        OptionsManager_setParamsTest.assertNotNull((Object)retParam);
        OptionsManager_setParamsTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamsTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
    }

    public void testSetParams_nullParameter_assertException() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        boolean exceptionOccured = false;
        try {
            mgr.setOptionsParameters(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        OptionsManager_setParamsTest.assertTrue((boolean)exceptionOccured);
    }
}

