/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import junit.framework.TestCase;
import org.nhindirect.stagent.cert.impl.LdapPublicCertUtilImpl;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;

public class LDAPPublicCertUtil_createLDAPUrl_Test
extends TestCase {
    public void testCreateLDAPUrl_singleSRVRecord() throws Exception {
        LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl();
        SRVRecord rec = new SRVRecord(new Name("test.com."), 1, 3600L, 0, 1, 339, new Name("ldap.test.com."));
        String url = impl.createLDAPUrl(new Record[]{rec});
        String[] urls = url.split(" ");
        LDAPPublicCertUtil_createLDAPUrl_Test.assertEquals((int)1, (int)urls.length);
        LDAPPublicCertUtil_createLDAPUrl_Test.assertTrue((boolean)urls[0].startsWith("ldap://ldap.test.com"));
    }

    public void testCreateLDAPUrl_multipleSRVRecord_descendingPriority_assertPriorityOrderDesc() throws Exception {
        LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl();
        SRVRecord rec1 = new SRVRecord(new Name("test.com."), 1, 3600L, 0, 1, 339, new Name("ldap1.test.com."));
        SRVRecord rec2 = new SRVRecord(new Name("test.com."), 1, 3600L, 1, 1, 339, new Name("ldap2.test.com."));
        String url = impl.createLDAPUrl(new Record[]{rec1, rec2});
        String[] urls = url.split(" ");
        LDAPPublicCertUtil_createLDAPUrl_Test.assertEquals((int)2, (int)urls.length);
        LDAPPublicCertUtil_createLDAPUrl_Test.assertTrue((boolean)urls[0].startsWith("ldap://ldap1.test.com"));
        LDAPPublicCertUtil_createLDAPUrl_Test.assertTrue((boolean)urls[1].startsWith("ldap://ldap2.test.com"));
    }

    public void testCreateLDAPUrl_multipleSRVRecord_ascendingPriority_assertPriorityOrderDesc() throws Exception {
        LdapPublicCertUtilImpl impl = new LdapPublicCertUtilImpl();
        SRVRecord rec1 = new SRVRecord(new Name("test.com."), 1, 3600L, 1, 1, 339, new Name("ldap1.test.com."));
        SRVRecord rec2 = new SRVRecord(new Name("test.com."), 1, 3600L, 0, 1, 339, new Name("ldap2.test.com."));
        String url = impl.createLDAPUrl(new Record[]{rec1, rec2});
        String[] urls = url.split(" ");
        LDAPPublicCertUtil_createLDAPUrl_Test.assertEquals((int)2, (int)urls.length);
        LDAPPublicCertUtil_createLDAPUrl_Test.assertTrue((boolean)urls[0].startsWith("ldap://ldap2.test.com"));
        LDAPPublicCertUtil_createLDAPUrl_Test.assertTrue((boolean)urls[1].startsWith("ldap://ldap1.test.com"));
    }
}

