/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.bouncycastle.cms.CMSSignedData;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.TrustModel;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustModel_findTrustedSignatureTest
extends TestCase {
    private X509Certificate sigUser1;
    private X509Certificate sigUser1CA;
    private X509Certificate otherCert;
    private IncomingMessage inMessage;
    private SignedEntity signedEntity;
    private SMIMECryptographerImpl cryptographer;

    public void setUp() throws Exception {
        CryptoExtensions.registerJCEProviders();
        this.sigUser1 = TestUtils.getInternalCert("user1");
        this.sigUser1CA = TestUtils.getInternalCACert("cacert");
        this.otherCert = TestUtils.loadCertificate("gm2552.der");
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        this.cryptographer = new SMIMECryptographerImpl();
        this.inMessage = new IncomingMessage(new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())));
        this.signedEntity = this.cryptographer.sign(this.inMessage.getMessage(), this.sigUser1);
        CMSSignedData signatures = this.cryptographer.deserializeSignatureEnvelope(this.signedEntity);
        this.inMessage.setSignature(signatures);
    }

    public void testFindTrustedSignatureTest_singleRecipSignature_nullRecip_assertMessageSignatureNotNull() throws Exception {
        TrustModel trustModel = new TrustModel();
        trustModel.findSenderSignatures(this.inMessage);
        DefaultMessageSignatureImpl impl = trustModel.findTrustedSignature(this.inMessage, Arrays.asList(this.sigUser1CA));
        TrustModel_findTrustedSignatureTest.assertNotNull((Object)impl);
    }

    public void testFindTrustedSignatureTest_singleRecipSignature_nonNullRecip_assertMessageSignatureNotNull() throws Exception {
        TrustModel trustModel = new TrustModel();
        trustModel.findSenderSignatures(this.inMessage);
        DefaultMessageSignatureImpl impl = trustModel.findTrustedSignature(this.inMessage, (InternetAddress)this.inMessage.getRecipients().get(0), Arrays.asList(this.sigUser1CA));
        TrustModel_findTrustedSignatureTest.assertNotNull((Object)impl);
    }

    public void testFindTrustedSignatureTest_singleRecipSignature_senderHasCert_assertMessageSignatureNotNull() throws Exception {
        TrustModel trustModel = new TrustModel();
        trustModel.findSenderSignatures(this.inMessage);
        this.inMessage.getSender().setCertificates(Arrays.asList(this.sigUser1));
        DefaultMessageSignatureImpl impl = trustModel.findTrustedSignature(this.inMessage, (InternetAddress)this.inMessage.getRecipients().get(0), Arrays.asList(this.sigUser1CA));
        TrustModel_findTrustedSignatureTest.assertNotNull((Object)impl);
    }

    public void testFindTrustedSignatureTest_singleRecipSignature_senderHasNonMatchingCert_assertMessageSignatureNotNull() throws Exception {
        TrustModel trustModel = new TrustModel();
        trustModel.findSenderSignatures(this.inMessage);
        this.inMessage.getSender().setCertificates(Arrays.asList(this.otherCert));
        DefaultMessageSignatureImpl impl = trustModel.findTrustedSignature(this.inMessage, (InternetAddress)this.inMessage.getRecipients().get(0), Arrays.asList(this.sigUser1CA));
        TrustModel_findTrustedSignatureTest.assertNotNull((Object)impl);
    }

    public void testFindTrustedSignatureTest_singleRecipSignature_notPolicyCompliant_assertMessageSignatureNull() throws Exception {
        TrustModel trustModel = new TrustModel(){

            protected boolean isCertPolicyCompliant(InternetAddress recipient, X509Certificate cert) {
                return false;
            }
        };
        trustModel.findSenderSignatures(this.inMessage);
        DefaultMessageSignatureImpl impl = trustModel.findTrustedSignature(this.inMessage, (InternetAddress)this.inMessage.getRecipients().get(0), Arrays.asList(this.sigUser1CA));
        TrustModel_findTrustedSignatureTest.assertNull((Object)impl);
    }
}

