/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail.notifications;

import com.sun.mail.dsn.DispositionNotification;
import java.util.ArrayList;
import java.util.Arrays;
import javax.mail.BodyPart;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import junit.framework.TestCase;
import org.apache.mailet.base.mail.MimeMultipartReport;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.mail.notifications.Disposition;
import org.nhindirect.stagent.mail.notifications.MDNFactory;
import org.nhindirect.stagent.mail.notifications.MdnGateway;
import org.nhindirect.stagent.mail.notifications.Notification;
import org.nhindirect.stagent.mail.notifications.NotificationType;

public class MDNFactory_createTest
extends TestCase {
    public static InternetHeaders getNotificationFieldsAsHeaders(MimeMultipart mm) {
        InternetHeaders retVal = null;
        if (mm == null) {
            throw new IllegalArgumentException("Multipart can not be null");
        }
        try {
            String[] fields;
            if (mm.getCount() < 2) {
                throw new IllegalArgumentException("Multipart can not be null");
            }
            BodyPart part = mm.getBodyPart(1);
            if (part.getContent() instanceof DispositionNotification) {
                return ((DispositionNotification)part.getContent()).getNotifications();
            }
            retVal = new InternetHeaders();
            for (String field : fields = Notification.getPartContentBodyAsString((BodyPart)part).split("\r\n")) {
                int idx = field.indexOf(":");
                if (idx <= -1) continue;
                String name = field.substring(0, idx);
                String value = field.substring(idx + 1).trim();
                retVal.setHeader(name, value);
            }
        }
        catch (Exception e) {
            throw new NHINDException("Failed to parse notification fields.", e);
        }
        return retVal;
    }

    public void testCreate_withGernalAttributes() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"", (String)"", new ArrayList());
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertTrue((boolean)headers.getHeader("Reporting-UA", ",").startsWith("junitUA"));
        MDNFactory_createTest.assertTrue((boolean)headers.getHeader("Reporting-UA", ",").endsWith("junitProduct"));
        MDNFactory_createTest.assertEquals((String)"rfc822; sender@send.com", (String)headers.getHeader("Original-Recipient", ","));
        MDNFactory_createTest.assertEquals((String)"rfc822; final@final.com", (String)headers.getHeader("Final-Recipient", ","));
        MDNFactory_createTest.assertTrue((boolean)headers.getHeader("MDN-Gateway", ",").endsWith("junitGateway"));
        MDNFactory_createTest.assertTrue((boolean)headers.getHeader("Disposition", ",").endsWith(NotificationType.Processed.toString()));
        BodyPart part0 = report.getBodyPart(0);
        Object obj = part0.getContent();
        MDNFactory_createTest.assertEquals((Object)"test", (Object)obj);
    }

    public void testCreate_withError() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"", (String)"", new ArrayList());
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"junit error", (String)headers.getHeader("Error", ","));
    }

    public void testCreate_withError_oldConstructor() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"junit error", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp);
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"junit error", (String)headers.getHeader("Error", ","));
    }

    public void testCreate_withWarning() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"junit warning", (String)"", new ArrayList());
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"junit warning", (String)headers.getHeader("Warning", ","));
    }

    public void testCreate_withFailure() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"", (String)"junit failure", new ArrayList());
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"junit failure", (String)headers.getHeader("Failure", ","));
    }

    public void testCreate_withExtensionNameOnly() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION"));
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"", (String)headers.getHeader("X-EXTENSION", ","));
    }

    public void testCreate_withExtensionNameWithValue() throws Exception {
        Disposition disp = new Disposition(NotificationType.Processed);
        MdnGateway gateway = new MdnGateway("junitGateway");
        MimeMultipartReport report = MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, (org.apache.jsieve.mailet.mdn.Disposition)disp, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION:junit value"));
        MDNFactory_createTest.assertNotNull((Object)report);
        InternetHeaders headers = MDNFactory_createTest.getNotificationFieldsAsHeaders((MimeMultipart)report);
        MDNFactory_createTest.assertEquals((String)"junit value", (String)headers.getHeader("X-EXTENSION", ","));
    }

    public void testCreate_noDisposition_assertException() throws Exception {
        MdnGateway gateway = new MdnGateway("junitGateway");
        boolean exceptionOccured = false;
        try {
            MDNFactory.create((String)"test", (String)"junitUA", (String)"junitProduct", (String)"sender@send.com", (String)"final@final.com", (String)"12345", (String)"", (MdnGateway)gateway, null, (String)"", (String)"junit failure", Arrays.asList("X-EXTENSION:junit value"));
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        MDNFactory_createTest.assertTrue((boolean)exceptionOccured);
    }
}

