/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator_getIntermediateCertsByAIATest;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_resolveIssuersTest
extends TestCase {
    public void testResolveIssuers_AIAExists_validateResolved() throws Exception {
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper validator = new TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                try {
                    this.retrievedURL = url;
                    return TestUtils.loadCertificate("CernerDirect Cert Professional Community CA.der");
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        ArrayList resolvedIssuers = new ArrayList();
        ArrayList anchors = new ArrayList();
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper spyValidator = (TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        spyValidator.resolveIssuers(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"), resolvedIssuers, 0, anchors);
        TrustChainValidator_resolveIssuersTest.assertEquals((int)1, (int)resolvedIssuers.size());
        TrustChainValidator_resolveIssuersTest.assertEquals((Object)TestUtils.loadCertificate("CernerDirect Cert Professional Community CA.der"), resolvedIssuers.iterator().next());
        ((TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)2)))).downloadCertFromAIA((String)Matchers.any());
    }

    public void testResolveIssuers_AIAExists_resolveToRoot_validateResolved() throws Exception {
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper validator = new TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                try {
                    if (url.contains("sandbox")) {
                        return TestUtils.loadCertificate("CernerDirect Cert Professional Community CA.der");
                    }
                    return TestUtils.loadCertificate("CernerRoot.der");
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        ArrayList resolvedIssuers = new ArrayList();
        ArrayList anchors = new ArrayList();
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper spyValidator = (TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        spyValidator.resolveIssuers(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"), resolvedIssuers, 0, anchors);
        TrustChainValidator_resolveIssuersTest.assertEquals((int)2, (int)resolvedIssuers.size());
        Iterator iter = resolvedIssuers.iterator();
        TrustChainValidator_resolveIssuersTest.assertEquals((Object)TestUtils.loadCertificate("CernerDirect Cert Professional Community CA.der"), iter.next());
        TrustChainValidator_resolveIssuersTest.assertEquals((Object)TestUtils.loadCertificate("CernerRoot.der"), iter.next());
        ((TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)2)))).downloadCertFromAIA((String)Matchers.any());
    }

    public void testResolveIssuers_noAIAExists_notAvailViaResolver_validateNotResolved() throws Exception {
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper validator = new TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                throw new NHINDException();
            }
        };
        validator.setCertificateResolver(new ArrayList());
        ArrayList resolvedIssuers = new ArrayList();
        ArrayList anchors = new ArrayList();
        TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper spyValidator = (TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        spyValidator.resolveIssuers(TestUtils.loadCertificate("altNameOnly.der"), resolvedIssuers, 0, anchors);
        TrustChainValidator_resolveIssuersTest.assertEquals((int)0, (int)resolvedIssuers.size());
        ((TrustChainValidator_getIntermediateCertsByAIATest.TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)0)))).downloadCertFromAIA((String)Matchers.any());
    }
}

