/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class X509CertificateEx
extends X509Certificate {
    private final PrivateKey privKey;
    private final X509Certificate internalCert;

    public static X509CertificateEx fromX509Certificate(X509Certificate cert, PrivateKey privKey) {
        if (cert == null || privKey == null) {
            throw new IllegalArgumentException();
        }
        return new X509CertificateEx(cert, privKey);
    }

    private X509CertificateEx(X509Certificate cert, PrivateKey _privKey) {
        this.internalCert = cert;
        this.privKey = _privKey;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.internalCert.checkValidity();
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.internalCert.checkValidity(date);
    }

    @Override
    public int getBasicConstraints() {
        return this.internalCert.getBasicConstraints();
    }

    @Override
    public List<String> getExtendedKeyUsage() throws CertificateParsingException {
        return this.internalCert.getExtendedKeyUsage();
    }

    @Override
    public Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        return this.internalCert.getIssuerAlternativeNames();
    }

    @Override
    public Principal getIssuerDN() {
        return this.internalCert.getIssuerDN();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return this.internalCert.getIssuerUniqueID();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        return this.internalCert.getIssuerX500Principal();
    }

    @Override
    public boolean[] getKeyUsage() {
        return this.internalCert.getKeyUsage();
    }

    @Override
    public Date getNotAfter() {
        return this.internalCert.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.internalCert.getNotBefore();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.internalCert.getSerialNumber();
    }

    @Override
    public String getSigAlgName() {
        return this.internalCert.getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return this.internalCert.getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.internalCert.getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return this.internalCert.getSignature();
    }

    @Override
    public Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        return this.internalCert.getSubjectAlternativeNames();
    }

    @Override
    public Principal getSubjectDN() {
        return this.internalCert.getSubjectDN();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return this.internalCert.getSubjectUniqueID();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.internalCert.getSubjectX500Principal();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return this.internalCert.getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return this.internalCert.getVersion();
    }

    @Override
    public boolean equals(Object other) {
        return this.internalCert.equals(other);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.internalCert.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.internalCert.getPublicKey();
    }

    @Override
    public int hashCode() {
        return this.internalCert.hashCode();
    }

    @Override
    public String toString() {
        return this.internalCert.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.internalCert.verify(key);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.internalCert.verify(key, sigProvider);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return this.internalCert.hasUnsupportedCriticalExtension();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return this.internalCert.getCriticalExtensionOIDs();
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return this.internalCert.getNonCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return this.internalCert.getExtensionValue(oid);
    }

    public boolean hasPrivateKey() {
        return this.privKey != null;
    }

    public PrivateKey getPrivateKey() {
        return this.privKey;
    }
}

