/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import javax.mail.Header;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.MessageEnvelope;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsManagerUtils;
import org.nhindirect.stagent.options.OptionsParameter;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustError;
import org.nhindirect.stagent.trust.TrustException;
import org.nhindirect.stagent.utils.TestUtils;

public class NHINDAgentTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    public void testEndToEndMessageWithCertKeyStore() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        NHINDAgentTest.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(SMIMEenvMessage.getMessage().toString());
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        NHINDAgentTest.assertNotNull((Object)processedMsg);
        NHINDAgentTest.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        NHINDAgentTest.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        InputStream inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        testMessage = TestUtils.readResource("LargeMsgWithAttachments.txt");
        originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        NHINDAgentTest.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        NHINDAgentTest.assertNotNull((Object)processedMsg);
        NHINDAgentTest.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        NHINDAgentTest.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        oStream = new ByteArrayOutputStream();
        buffer = new byte[1024];
        count = 0;
        inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        testMessage = TestUtils.readResource("MDNResponse.txt");
        originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        NHINDAgentTest.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        NHINDAgentTest.assertNotNull((Object)processedMsg);
        NHINDAgentTest.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        oStream = new ByteArrayOutputStream();
        buffer = new byte[1024];
        count = 0;
        inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
    }

    public void testDecryptProvidedMessage() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncryptedMessage2.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(originalMsg);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testDecryptAttachmentMessage() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        String testMessage = TestUtils.readResource("EncAttachment.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming(originalMsg);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
    }

    public void testEndToEndMessageBase64AttachmentOnly() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("raw2.txt");
        MimeMessage originalMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        NHINDAgentTest.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        NHINDAgentTest.assertNotNull((Object)processedMsg);
        NHINDAgentTest.assertTrue((processedMsg.getContentType().compareTo(originalMsg.getContentType()) == 0 ? 1 : 0) != 0);
        NHINDAgentTest.assertTrue((originalMsg.getSubject().compareTo(processedMsg.getSubject()) == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int count = 0;
        InputStream inStream = originalMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
        oStream = new ByteArrayOutputStream();
        count = 0;
        inStream = processedMsg.getInputStream();
        while ((count = inStream.read(buffer)) > -1) {
            oStream.write(buffer, 0, count);
        }
    }

    public void testOutgoingMessageIsWrappedCorrectly() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("raw2.txt");
        Message wrappedMessage = agent.wrapMessage(testMessage);
        NHINDAgentTest.assertNotNull((Object)wrappedMessage);
        NHINDAgentTest.assertTrue((wrappedMessage.toString().length() > 0 ? 1 : 0) != 0);
        NHINDAgentTest.assertEquals((String)"message/rfc822", (String)wrappedMessage.getContentType());
        ArrayList<String> headers = new ArrayList<String>();
        Enumeration allHeaders = wrappedMessage.getAllHeaders();
        while (allHeaders.hasMoreElements()) {
            Header header = (Header)allHeaders.nextElement();
            headers.add(header.getName());
        }
        NHINDAgentTest.assertTrue((boolean)headers.contains("MIME-Version"));
        NHINDAgentTest.assertTrue((boolean)headers.contains("From"));
        NHINDAgentTest.assertTrue((boolean)headers.contains("To"));
        NHINDAgentTest.assertTrue((boolean)headers.contains("Message-ID"));
        NHINDAgentTest.assertFalse((boolean)headers.contains("Subject"));
    }

    public void testMessageWithUntrustedRecipient_OutboundMessageHasRejectedRecips() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("MessageWithAUntrustedRecipient.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        NHINDAgentTest.assertTrue((SMIMEenvMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        NHINDAgentTest.assertTrue((boolean)SMIMEenvMessage.hasRejectedRecipients());
        NHINDAgentTest.assertNull((Object)SMIMEenvMessage.getMessage().getCCHeader());
        agent = TestUtils.getStockAgent(Arrays.asList("securehealthemail.com"));
        IncomingMessage strippedAndVerifiesMessage = agent.processIncoming((MessageEnvelope)SMIMEenvMessage);
        NHINDAgentTest.assertNotNull((Object)strippedAndVerifiesMessage);
        NHINDAgentTest.assertTrue((strippedAndVerifiesMessage.getMessage().toString().length() > 0 ? 1 : 0) != 0);
        MimeMessage processedMsg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(strippedAndVerifiesMessage.getMessage().toString().getBytes("ASCII")));
        NHINDAgentTest.assertNotNull((Object)processedMsg);
    }

    public void testMessageWithAllUntrustedRecipients_AgentRejectsTheMessageCompletely() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("messaging.cernerdemos.com"));
        String testMessage = TestUtils.readResource("MessageWithAllUntrustedRecipients.txt");
        OutgoingMessage SMIMEenvMessage = null;
        try {
            SMIMEenvMessage = agent.processOutgoing(testMessage);
        }
        catch (NHINDException e) {
            AgentException agentexception = (AgentException)((Object)e.m_error);
            NHINDAgentTest.assertEquals((Object)AgentError.NoTrustedRecipients, (Object)agentexception.getError());
        }
        NHINDAgentTest.assertNull((Object)SMIMEenvMessage);
    }

    public void testIncomingMDN_incomingNotTrusted_outgoingTrusted_assertMDNMessageTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "true"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        NHINDAgentTest.assertNotNull((Object)incomingMessage);
    }

    public void testIncomingDSN_incomingNotTrusted_outgoingTrusted_assertMDNMessageTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "true"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("DSNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        NHINDAgentTest.assertNotNull((Object)incomingMessage);
    }

    public void testIncomingNormalMessage_incomingNotTrusted_outgoingTrusted_assertMessageNotTrusted() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            TrustException agentexception = (TrustException)e.m_error;
            NHINDAgentTest.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)agentexception.getError());
        }
        NHINDAgentTest.assertNull((Object)incomingMessage);
    }

    public void testIncomingMDN_incomingNotTrusted_outgoingTrusted_useIncomingSettingFalse_assertMDNMessageNotTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "false"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("MDNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            TrustException agentexception = (TrustException)e.m_error;
            NHINDAgentTest.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)agentexception.getError());
        }
        NHINDAgentTest.assertNull((Object)incomingMessage);
    }

    public void testIncomingDSN_incomingNotTrusted_outgoingTrusted_useIncomingSettingFalse_assertMDNMessageNotTrusted() throws Exception {
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("UseOutgoingPolicyForIncomingNotifications", "false"));
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("starugh-stateline.com"));
        String testMessage = TestUtils.readResource("DSNMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        NHINDAgentTest.assertNotNull((Object)SMIMEenvMessage);
        agent = TestUtils.getStockAgent(Arrays.asList("Cerner.com"));
        DefaultTrustAnchorResolver resolver = (DefaultTrustAnchorResolver)agent.getTrustAnchors();
        CertificateResolver mockResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        DefaultTrustAnchorResolver newResolver = new DefaultTrustAnchorResolver(resolver.getOutgoingAnchors(), mockResolver);
        agent.setTrustAnchorResolver((TrustAnchorResolver)newResolver);
        IncomingMessage incomingMessage = null;
        try {
            incomingMessage = agent.processIncoming((MimeMessage)SMIMEenvMessage.getMessage());
        }
        catch (NHINDException e) {
            TrustException agentexception = (TrustException)e.m_error;
            NHINDAgentTest.assertEquals((Object)TrustError.NoTrustedRecipients, (Object)agentexception.getError());
        }
        NHINDAgentTest.assertNull((Object)incomingMessage);
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.defaultlog", "trace");
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            System.out.println("Name: " + entry.getKey() + " Value: " + entry.getValue());
        }
    }
}

