/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.unit.AbstractServerTest;
import org.apache.directory.shared.ldap.ldif.Entry;
import org.nhindirect.ldap.LDAPResearchTest;
import org.nhindirect.ldap.PrivkeySchema;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.nhindirect.stagent.cert.impl.LdapEnvironment;
import org.nhindirect.stagent.utils.BaseTestPlan;

public class LDAPCertificateStore_functional_test
extends AbstractServerTest {
    public void setUp() throws Exception {
        MutablePartitionConfiguration pcfg = new MutablePartitionConfiguration();
        pcfg.setName("lookupTest");
        pcfg.setSuffix("cn=lookupTest");
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("objectClass");
        indexedAttrs.add("cn");
        pcfg.setIndexedAttributes(indexedAttrs);
        BasicAttributes attrs = new BasicAttributes(true);
        BasicAttribute attr = new BasicAttribute("objectClass");
        attr.add("top");
        attrs.put(attr);
        pcfg.setContextEntry((Attributes)attrs);
        HashSet<MutablePartitionConfiguration> pcfgs = new HashSet<MutablePartitionConfiguration>();
        pcfgs.add(pcfg);
        this.configuration.setContextPartitionConfigurations(pcfgs);
        this.configuration.setWorkingDirectory(new File("LDAP-TEST"));
        Set schemas = this.configuration.getBootstrapSchemas();
        schemas.add(new PrivkeySchema());
        this.configuration.setBootstrapSchemas(schemas);
        super.setUp();
    }

    public void testGetWildCardSearch_assertAllCertsFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "*";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                String address = CryptoExtensions.getSubjectAddress((X509Certificate)certs.iterator().next());
                Assert.assertEquals((String)"gm2552@securehealthemail.com", (String)address);
            }
        }.perform();
    }

    public void testGetWildCardSearch_assertNoCertsFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "c*";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)0, (int)certs.size());
            }
        }.perform();
    }

    public void testGetAllCertificates_assertAllCertsFound() throws Exception {
        new TestPlan(){

            @Override
            protected void performInner() throws Exception {
                Collection certs = this.certStore.getAllCertificates();
                this.doAssertions(certs);
            }

            @Override
            protected String getSubjectToSearch() throws Exception {
                return "";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                String address = CryptoExtensions.getSubjectAddress((X509Certificate)certs.iterator().next());
                Assert.assertEquals((String)"gm2552@securehealthemail.com", (String)address);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int port;
        protected LDAPCertificateStore certStore;

        TestPlan() {
        }

        @Override
        protected void setupMocks() {
            try {
                InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream("ldifs/privCertsOnly.ldif");
                if (stream == null) {
                    throw new IOException("Failed to load ldif file");
                }
                LDAPCertificateStore_functional_test.this.importLdif(stream);
                this.createLdapEntries();
                this.port = LDAPCertificateStore_functional_test.this.configuration.getLdapPort();
                File fl = new File("NHINKeyStore");
                if (fl.exists()) {
                    fl.delete();
                }
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                env.put("java.naming.provider.url", "ldap://localhost:" + this.port);
                env.put("java.naming.security.authentication", "none");
                LdapEnvironment ldapEnvironment = new LdapEnvironment(env, "privKeyStore", "ou=cerner, ou=com, cn=lookupTest", "email");
                LdapCertUtilImpl impl = new LdapCertUtilImpl(ldapEnvironment, "", "X509");
                this.certStore = new LDAPCertificateStore(impl, null, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        protected void createLdapEntries() throws NamingException {
            Entry entry = new Entry();
            entry.addAttribute("objectClass", (Object)"organizationalUnit");
            entry.addAttribute("objectClass", (Object)"top");
            entry.addAttribute("objectClass", (Object)"userPrivKey");
            entry.addAttribute("email", (Object)"gm2552@cerner.com");
            File fl = new File("testfile");
            int idx = fl.getAbsolutePath().lastIndexOf("testfile");
            String path = fl.getAbsolutePath().substring(0, idx);
            byte[] buffer = new byte[(int)new File(path + "src/test/resources/certs/gm2552.der").length() + 100];
            try {
                InputStream stream = LDAPResearchTest.class.getClassLoader().getResourceAsStream("certs/gm2552.der");
                stream.read(buffer);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Base64 base64 = new Base64();
            String certificateValue = new String(base64.encode(buffer));
            entry.addAttribute("privKeyStore", (Object)certificateValue);
            entry.addAttribute("ou", (Object)"gm2552");
            LDAPCertificateStore_functional_test.this.rootDSE.createSubcontext("ou=gm2552, ou=privKeys, ou=cerner, ou=com, cn=lookupTest", entry.getAttributes());
        }

        @Override
        protected void performInner() throws Exception {
            String subjectToSearch = this.getSubjectToSearch();
            Collection certs = this.certStore.getCertificates(subjectToSearch);
            this.doAssertions(certs);
        }

        @Override
        protected void tearDownMocks() {
        }

        protected abstract String getSubjectToSearch() throws Exception;

        protected abstract void doAssertions(Collection<X509Certificate> var1) throws Exception;
    }
}

