/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.security.cert.X509Certificate;
import java.util.Collection;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_getIntermediateCertsByAIATest
extends TestCase {
    public void testGetIntermediateCertsByAIA_AIAExists_validateResolved() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                try {
                    this.retrievedURL = url;
                    return TestUtils.loadCertificate("bob.der");
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"));
        TrustChainValidator_getIntermediateCertsByAIATest.assertEquals((String)"http://sandboxcernerdirect.com/professional/public/subordinate.der", (String)spyValidator.retrievedURL);
        TrustChainValidator_getIntermediateCertsByAIATest.assertEquals((int)1, (int)downloadedCerts.size());
        TrustChainValidator_getIntermediateCertsByAIATest.assertEquals((Object)TestUtils.loadCertificate("bob.der"), downloadedCerts.iterator().next());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)1)))).downloadCertFromAIA((String)Matchers.any());
    }

    public void testGetIntermediateCertsByAIA_emptyAIA_validateNotResolved() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                try {
                    this.retrievedURL = url;
                    return TestUtils.loadCertificate("bob.der");
                }
                catch (Exception e) {
                    throw new NHINDException((Object)e);
                }
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("altNameOnly.der"));
        TrustChainValidator_getIntermediateCertsByAIATest.assertNull((Object)spyValidator.retrievedURL);
        TrustChainValidator_getIntermediateCertsByAIATest.assertEquals((int)0, (int)downloadedCerts.size());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.never()))).downloadCertFromAIA((String)Matchers.any());
    }

    public void testGetIntermediateCertsByAIA_errorInDownload_validateEmpty() throws Exception {
        TrustChainValidatorWrapper validator = new TrustChainValidatorWrapper(){

            protected X509Certificate downloadCertFromAIA(String url) throws NHINDException {
                throw new NHINDException();
            }
        };
        TrustChainValidatorWrapper spyValidator = (TrustChainValidatorWrapper)((Object)Mockito.spy((Object)((Object)validator)));
        Collection downloadedCerts = spyValidator.getIntermediateCertsByAIA(TestUtils.loadCertificate("demo.sandboxcernerdirect.com.der"));
        TrustChainValidator_getIntermediateCertsByAIATest.assertNull((Object)spyValidator.retrievedURL);
        TrustChainValidator_getIntermediateCertsByAIATest.assertEquals((int)0, (int)downloadedCerts.size());
        ((TrustChainValidatorWrapper)((Object)Mockito.verify((Object)((Object)spyValidator), (VerificationMode)Mockito.times((int)1)))).downloadCertFromAIA((String)Matchers.any());
    }

    static class TrustChainValidatorWrapper
    extends TrustChainValidator {
        public String retrievedURL;

        TrustChainValidatorWrapper() {
        }
    }
}

