/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.mail.internet.InternetAddress;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.utils.BaseTestPlan;

public class KeyStoreCertificateStore_GetCertificates_Test
extends TestCase {
    public void testKeyStoreSearch_GetWithAltName_AssertCertsFoundUsingAltSubject() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "test.email.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertTrue((boolean)this.certFoundInAltSubject);
            }
        }.perform();
    }

    public void testKeyStoreSearch_GetUserCertByDomain_AssertCertsNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "hospitalA.direct.visionshareinc.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNull(certs);
            }
        }.perform();
    }

    public void testKeyStoreSearch_GetUnknownUserCert_AssertCertsNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "joe@hospitalA.direct.visionshareinc.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNull(null);
            }
        }.perform();
    }

    public void testKeyStoreSearch_GetOrgCertAltName_AssertCertsFoundUsingAltSubject() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "test.email.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertTrue((boolean)this.certFoundInAltSubject);
            }
        }.perform();
    }

    public void testKeyStoreSearch_GetWithDN_AssertCertsFoundNotUsingAltSubject() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "gm2552@securehealthemail.com";
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
                Assert.assertNotNull(certs);
                Assert.assertEquals((int)1, (int)certs.size());
                Assert.assertFalse((boolean)this.certFoundInAltSubject);
            }
        }.perform();
    }

    public void testKeyStoreSearch_GetExpiredCert_AssertCertsNotFound() throws Exception {
        new TestPlan(){

            @Override
            protected String getSubjectToSearch() {
                return "expired@testexpired.email.com";
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNotNull((Object)(exception != null ? 1 : 0));
                Assert.assertTrue((boolean)(exception instanceof NHINDException));
                NHINDException ex = (NHINDException)((Object)NHINDException.class.cast(exception));
                Assert.assertEquals((Object)ex.getError(), (Object)AgentError.AllCertsInResolverInvalid);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> certs) throws Exception {
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected CertificateResolver keyStore = null;
        protected boolean certFoundInAltSubject = false;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            this.keyStore = new KeyStoreCertificateStore("src/test/resources/keystores/internalKeystore", "h3||0 wor|d", "pKpa$$wd"){

                public Collection<X509Certificate> getCertificates(String subjectName) {
                    ArrayList<X509Certificate> retVal = new ArrayList<X509Certificate>();
                    Collection certs = this.getAllCertificates();
                    if (certs == null) {
                        return retVal;
                    }
                    for (X509Certificate cert : certs) {
                        if (CryptoExtensions.containsEmailAddressInSubjectAltName((X509Certificate)cert, (String)subjectName)) {
                            TestPlan.this.certFoundInAltSubject = true;
                            retVal.add(cert);
                            continue;
                        }
                        if (!cert.getSubjectDN().getName().toLowerCase().contains(subjectName.toLowerCase(Locale.getDefault()))) continue;
                        retVal.add(cert);
                    }
                    return retVal;
                }
            };
            InternetAddress address = new InternetAddress(this.getSubjectToSearch());
            Collection foundCerts = this.keyStore.getCertificates(address);
            this.doAssertions(foundCerts);
        }

        protected abstract String getSubjectToSearch();

        protected abstract void doAssertions(Collection<X509Certificate> var1) throws Exception;
    }
}

