/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.policy.impl;

import java.util.Collection;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.stagent.policy.impl.UniversalPolicyResolver;

public class UniversalPolicyResolver_getPolicyTest
extends TestCase {
    public void testGetOutgoingPolicy_assertPolicyRetrieved() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        Collection policies = resolver.getOutgoingPolicy(new InternetAddress("me@you.com"));
        UniversalPolicyResolver_getPolicyTest.assertEquals((int)1, (int)policies.size());
        UniversalPolicyResolver_getPolicyTest.assertEquals((Object)expression, policies.iterator().next());
    }

    public void testGetOutgoingPolicy_nullAddress_assertException() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        boolean execptionOccured = false;
        try {
            resolver.getOutgoingPolicy(null);
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        UniversalPolicyResolver_getPolicyTest.assertTrue((boolean)execptionOccured);
    }

    public void testGetIncomingPolicy_assertPolicyRetrieved() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        Collection policies = resolver.getIncomingPolicy(new InternetAddress("me@you.com"));
        UniversalPolicyResolver_getPolicyTest.assertEquals((int)1, (int)policies.size());
        UniversalPolicyResolver_getPolicyTest.assertEquals((Object)expression, policies.iterator().next());
    }

    public void testGetIncomingPolicy_nullAddress_assertException() throws Exception {
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        UniversalPolicyResolver resolver = new UniversalPolicyResolver(expression);
        boolean execptionOccured = false;
        try {
            resolver.getIncomingPolicy(null);
        }
        catch (IllegalArgumentException e) {
            execptionOccured = true;
        }
        UniversalPolicyResolver_getPolicyTest.assertTrue((boolean)execptionOccured);
    }
}

