/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.testmodules;

import com.google.inject.AbstractModule;
import java.util.Arrays;
import java.util.List;
import org.nhindirect.stagent.annotation.PrivateCerts;
import org.nhindirect.stagent.annotation.PublicCerts;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFile;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFilePassword;
import org.nhindirect.stagent.cert.impl.annotation.CertStoreKeyFilePrivKeyPassword;
import org.nhindirect.stagent.utils.TestUtils;

public class CertResolverTestModule
extends AbstractModule {
    private final String keyStoreFile;
    private final String keyStorePassword;
    private final String keyStorePrivPassword;

    public CertResolverTestModule(String keyStoreFileName, String keyStorePassword, String keyStorePrivPassword) {
        this.keyStoreFile = keyStoreFileName;
        this.keyStorePassword = keyStorePassword;
        this.keyStorePrivPassword = keyStorePrivPassword;
    }

    protected void configure() {
        KeyStoreCertificateStore resolver = new KeyStoreCertificateStore(this.keyStoreFile, this.keyStorePassword, this.keyStorePrivPassword);
        List<CertificateResolver> certResolvers = Arrays.asList(resolver);
        this.bindConstant().annotatedWith(CertStoreKeyFile.class).to(this.keyStoreFile);
        this.bindConstant().annotatedWith(CertStoreKeyFilePassword.class).to(this.keyStorePassword);
        this.bindConstant().annotatedWith(CertStoreKeyFilePrivKeyPassword.class).to(this.keyStorePrivPassword);
        this.bind(CertificateResolver.class).annotatedWith(PrivateCerts.class).to(KeyStoreCertificateStore.class);
        this.bind(TestUtils.collectionOf(CertificateResolver.class)).annotatedWith(PublicCerts.class).toInstance(certResolvers);
    }
}

