/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAgent;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.policy.PolicyResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultNHINDAgent_bindAddressesIncomingMessageTest
extends TestCase {
    protected IncomingMessage buildIncomingMessage(String fileName) throws Exception {
        String testMessage = TestUtils.readResource(fileName);
        Message incoming = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        return new IncomingMessage(incoming);
    }

    public void testBindAddresses_noPrivateCerts_assertNoBoundPrivateCerts() throws Exception {
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("starugh-stateline.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        IncomingMessage message = this.buildIncomingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            DefaultNHINDAgent_bindAddressesIncomingMessageTest.assertEquals((int)0, (int)recipient.getCertificates().size());
        }
    }

    public void testBindAddresses_singlePrivateCerts_notFiltered_assertBoundPrivateCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(cert));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("starugh-stateline.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        IncomingMessage message = this.buildIncomingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            DefaultNHINDAgent_bindAddressesIncomingMessageTest.assertEquals((int)1, (int)recipient.getCertificates().size());
        }
    }

    public void testBindAddresses_singlePrivateCerts_plicyFiltered_assertNoBoundPrivateCerts() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        CertificateResolver publicCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)publicCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        CertificateResolver privateCertResolver = (CertificateResolver)Mockito.mock(CertificateResolver.class);
        Mockito.when((Object)privateCertResolver.getCertificates((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(cert));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("starugh-stateline.com", privateCertResolver, publicCertResolver, (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class)){

            protected Collection<X509Certificate> filterCertificatesByPolicy(InternetAddress sender, PolicyResolver resolver, Collection<X509Certificate> certsToFilter, boolean incoming) {
                return Collections.emptyList();
            }
        };
        IncomingMessage message = this.buildIncomingMessage("MultipartMimeMessage.txt");
        message.setAgent((NHINDAgent)agent);
        agent.bindAddresses(message);
        for (NHINDAddress recipient : message.getRecipients()) {
            DefaultNHINDAgent_bindAddressesIncomingMessageTest.assertEquals((int)0, (int)recipient.getCertificates().size());
        }
    }
}

