/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import junit.framework.TestCase;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.DefaultCertStoreCachePolicy;
import org.nhindirect.stagent.cert.impl.CacheableKeyStoreManagerCertificateStore;

public class CacheableKeyStoreManagerCertificateStore_constructTest
extends TestCase {
    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
    }

    public void tearDown() {
        CertCacheFactory.getInstance().flushAll();
    }

    public void testContrust_defaultConstructor_assertNullStore() throws Exception {
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore();
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNull((Object)store.storeMgr);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)1000, (int)store.cachePolicy.getMaxItems());
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)3600, (int)store.cachePolicy.getSubjectTTL());
    }

    public void testContrust_providedStore_assertNonEmptyStore() throws Exception {
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNotNull((Object)store.storeMgr);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)1000, (int)store.cachePolicy.getMaxItems());
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)3600, (int)store.cachePolicy.getSubjectTTL());
    }

    public void testContrust_providedStoreAndCachePolicy_assertNonEmptyStoreAndCustomPolicy() throws Exception {
        DefaultCertStoreCachePolicy policy = new DefaultCertStoreCachePolicy();
        policy.setMaxItems(456);
        policy.setSubjectTTL(999);
        BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
        CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr, (CertStoreCachePolicy)policy);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNotNull((Object)store.storeMgr);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)456, (int)store.cachePolicy.getMaxItems());
        CacheableKeyStoreManagerCertificateStore_constructTest.assertEquals((int)999, (int)store.cachePolicy.getSubjectTTL());
    }
}

