/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import java.util.HashMap;
import java.util.UUID;
import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager_addInitParametersTest
extends TestCase {
    public void setUp() {
        OptionsManager.INSTANCE = null;
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddInitParameters_optionsDoNotInitallyExist() {
        String jvmPropValue = UUID.randomUUID().toString();
        System.setProperty("doesntexist1", jvmPropValue);
        OptionsParameter param = OptionsManager.getInstance().getParameter("DOESNTEXIST1");
        OptionsManager_addInitParametersTest.assertNull((Object)param);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("DOESNTEXIST1", "doesntexist1");
        OptionsManager.addInitParameters(map);
        try {
            param = OptionsManager.getInstance().getParameter("DOESNTEXIST1");
            OptionsManager_addInitParametersTest.assertNotNull((Object)param);
            OptionsManager_addInitParametersTest.assertEquals((String)jvmPropValue, (String)param.getParamValue());
        }
        finally {
            System.setProperty("doesntexist1", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddInitParameters_noInstance_optionsDoNotInitallyExist() {
        String jvmPropValue = UUID.randomUUID().toString();
        System.setProperty("doesntexist1", jvmPropValue);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("DOESNTEXIST1", "doesntexist1");
        OptionsManager_addInitParametersTest.assertNull((Object)OptionsManager.INSTANCE);
        OptionsManager.addInitParameters(map);
        try {
            OptionsParameter param = OptionsManager.getInstance().getParameter("DOESNTEXIST1");
            OptionsManager_addInitParametersTest.assertNotNull((Object)param);
            OptionsManager_addInitParametersTest.assertEquals((String)jvmPropValue, (String)param.getParamValue());
        }
        finally {
            System.setProperty("doesntexist1", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddInitParameters_optionsInitallyExist() {
        String jvmPropValue = UUID.randomUUID().toString();
        System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", jvmPropValue);
        OptionsParameter param = OptionsManager.getInstance().getParameter("LDAP_CERT_RESOLVER_MAX_CACHE_SIZE");
        OptionsManager_addInitParametersTest.assertNotNull((Object)param);
        String jvmPropValue2 = UUID.randomUUID().toString();
        System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", jvmPropValue2);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("LDAP_CERT_RESOLVER_MAX_CACHE_SIZE", "org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize");
        OptionsManager.addInitParameters(map);
        try {
            param = OptionsManager.getInstance().getParameter("LDAP_CERT_RESOLVER_MAX_CACHE_SIZE");
            OptionsManager_addInitParametersTest.assertNotNull((Object)param);
            OptionsManager_addInitParametersTest.assertEquals((String)jvmPropValue2, (String)param.getParamValue());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", "");
        }
    }
}

