/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.internet.MimeBodyPart;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.impl.BootstrappedPKCS11Credential;
import org.nhindirect.common.crypto.impl.StaticPKCS11TokenKeyStoreProtectionManager;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.CacheableKeyStoreManagerCertificateStore;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformation;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformationFactory;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.utils.TestUtils;

public class SplitDirectRecipientInformation_getDecryptedContentTest
extends TestCase {
    protected X509Certificate encCert;
    protected String pkcs11ProvName;

    protected SMIMEEnveloped createSMIMEEnv() throws Exception {
        return this.createSMIMEEnv(null);
    }

    protected SMIMEEnveloped createSMIMEEnv(X509Certificate cert) throws Exception {
        this.encCert = cert == null ? TestUtils.getInternalCert("user1") : cert;
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SMIMECryptographerImpl encryptor = new SMIMECryptographerImpl();
        return new SMIMEEnveloped((MimeBodyPart)encryptor.encrypt(entity, Arrays.asList(this.encCert)));
    }

    public void testGetDecryptedContent_sameDefaultEncAndKeyEncProvider_assertDecrypted() throws Exception {
        SMIMEEnveloped env = this.createSMIMEEnv();
        RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory();
        SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
        SplitDirectRecipientInformation_getDecryptedContentTest.assertNotNull((Object)recInfo.getDecryptedContent((Key)((X509CertificateEx)this.encCert).getPrivateKey()));
    }

    public void testGetDecryptedContent_differentEncAndKeyEncProvider_assertDecrypted() throws Exception {
        SMIMEEnveloped env = this.createSMIMEEnv();
        RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory("SunJCE", "BC");
        SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
        SplitDirectRecipientInformation_getDecryptedContentTest.assertNotNull((Object)recInfo.getDecryptedContent((Key)((X509CertificateEx)this.encCert).getPrivateKey()));
    }

    public void testGetDecryptedContent_safeNetHSMKeyEncProvider_assertDecrypted() throws Exception {
        this.pkcs11ProvName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((String)this.pkcs11ProvName)) {
            BootstrappedPKCS11Credential cred = new BootstrappedPKCS11Credential("1Kingpuff");
            StaticPKCS11TokenKeyStoreProtectionManager mgr = new StaticPKCS11TokenKeyStoreProtectionManager((PKCS11Credential)cred, "", "");
            CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr);
            store.add((X509Certificate)TestUtils.getInternalCert("user1"));
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            X509CertificateEx decryptCert = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                Certificate pkcs11Cert = ks.getCertificate(alias);
                if (pkcs11Cert == null || !(pkcs11Cert instanceof X509Certificate) || (key = ks.getKey(alias, null)) == null || !(key instanceof PrivateKey) || !CryptoExtensions.certSubjectContainsName((X509Certificate)((X509Certificate)pkcs11Cert), (String)"user1@cerner.com")) continue;
                decryptCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)pkcs11Cert), (PrivateKey)((PrivateKey)key));
                break;
            }
            SMIMEEnveloped env = this.createSMIMEEnv();
            RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
            SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory(this.pkcs11ProvName, "BC");
            SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
            SplitDirectRecipientInformation_getDecryptedContentTest.assertNotNull((Object)recInfo.getDecryptedContent((Key)decryptCert.getPrivateKey()));
        }
    }

    public void testGetDecryptedContent_safeNetHSMKeyEncProvider_differntEncCert_assertNotDecrypted() throws Exception {
        this.pkcs11ProvName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((String)this.pkcs11ProvName)) {
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            X509CertificateEx decryptCert = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                Certificate pkcs11Cert = ks.getCertificate(alias);
                if (pkcs11Cert == null || !(pkcs11Cert instanceof X509Certificate) || (key = ks.getKey(alias, null)) == null || !(key instanceof PrivateKey) || !CryptoExtensions.certSubjectContainsName((X509Certificate)((X509Certificate)pkcs11Cert), (String)"user1@cerner.com")) continue;
                decryptCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)pkcs11Cert), (PrivateKey)((PrivateKey)key));
                break;
            }
            this.encCert = TestUtils.getInternalCert("gm2552");
            SMIMEEnveloped env = this.createSMIMEEnv(this.encCert);
            RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
            SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory(this.pkcs11ProvName, "BC");
            SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
            boolean exceptionOccured = false;
            try {
                recInfo.getDecryptedContent((Key)decryptCert.getPrivateKey());
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            SplitDirectRecipientInformation_getDecryptedContentTest.assertTrue((boolean)exceptionOccured);
        }
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

