/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.stagent.CryptoExtensions;

public class MessageSigInspector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.exit(-1);
        }
        String messgefile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                System.err.println("Error: Unexpected argument [" + arg + "]\n");
                System.exit(-1);
                continue;
            }
            if (arg.equalsIgnoreCase("-msgFile")) {
                if (i == args.length - 1 || args[i + 1].startsWith("-")) {
                    System.err.println("Error: Missing message file");
                    System.exit(-1);
                }
                messgefile = args[++i];
                continue;
            }
            if (arg.equals("-help")) {
                System.exit(-1);
                continue;
            }
            System.err.println("Error: Unknown argument " + arg + "\n");
            System.exit(-1);
        }
        if (messgefile == null) {
            System.err.println("Error: missing message file\n");
        }
        FileInputStream inStream = null;
        try {
            inStream = FileUtils.openInputStream((File)new File(messgefile));
            MimeMessage message = new MimeMessage(null, (InputStream)inStream);
            MimeMultipart mm = (MimeMultipart)message.getContent();
            CMSSignedData signed = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart(mm.getBodyPart(0)), mm.getBodyPart(1).getInputStream());
            CertStore certs = signed.getCertificatesAndCRLs("Collection", CryptoExtensions.getJCEProviderName());
            SignerInformationStore signers = signed.getSignerInfos();
            Collection c = signers.getSigners();
            System.out.println("Found " + c.size() + " signers");
            int cnt = 1;
            for (SignerInformation signer : c) {
                Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signer.getSID());
                if (certCollection == null || certCollection.size() <= 0) continue;
                X509Certificate cert = (X509Certificate)certCollection.iterator().next();
                System.out.println("\r\nInfo for certificate " + cnt++);
                System.out.println("\tSubject " + cert.getSubjectDN());
                FileUtils.writeByteArrayToFile((File)new File("SigCert.der"), (byte[])cert.getEncoded());
                byte[] bytes = cert.getExtensionValue("2.5.29.15");
                if (bytes != null) {
                    DERObject obj = MessageSigInspector.getObject(bytes);
                    KeyUsage keyUsage = new KeyUsage((DERBitString)obj);
                    byte[] data = keyUsage.getBytes();
                    int intValue = data.length == 1 ? data[0] & 0xFF : (data[1] & 0xFF) << 8 | data[0] & 0xFF;
                    System.out.println("\tKey Usage: " + intValue);
                } else {
                    System.out.println("\tKey Usage: NONE");
                }
                Attribute digAttr = signer.getSignedAttributes().get(CMSAttributes.messageDigest);
                DERObject hashObj = digAttr.getAttrValues().getObjectAt(0).getDERObject();
                byte[] signedDigest = ((ASN1OctetString)hashObj).getOctets();
                String signedDigestHex = Hex.encodeHexString((byte[])signedDigest);
                System.out.println("\r\nSigned Message Digest: " + signedDigestHex);
                try {
                    signer.verify(cert, "BC");
                    System.out.println("Signature verified.");
                }
                catch (CMSException e) {
                    System.out.println("Signature failed to verify.");
                }
                byte[] digest = signer.getContentDigest();
                String digestHex = Hex.encodeHexString((byte[])digest);
                System.out.println("\r\nComputed Message Digest: " + digestHex);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inStream);
        }
        IOUtils.closeQuietly((InputStream)inStream);
    }

    protected static DERObject getObject(byte[] ext) throws PolicyProcessException {
        DERObject dERObject;
        ASN1InputStream aIn = null;
        try {
            aIn = new ASN1InputStream(ext);
            ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
            IOUtils.closeQuietly((InputStream)aIn);
            aIn = new ASN1InputStream(octs.getOctets());
            dERObject = aIn.readObject();
        }
        catch (Exception e) {
            try {
                throw new PolicyProcessException("Exception processing data ", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)aIn);
        return dERObject;
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

