/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.activekeyops.DirectSignedDataGenerator;

public class SplitProviderDirectSignedDataGenerator
extends CMSSignedDataGenerator
implements DirectSignedDataGenerator {
    protected final String sigProvider;
    protected final String digestProvider;
    protected final List<DirectTargetedSignerInf> privateSigners = new ArrayList<DirectTargetedSignerInf>();

    public SplitProviderDirectSignedDataGenerator(String sigProvider, String digestProvider) {
        this.sigProvider = StringUtils.isEmpty((String)sigProvider) ? CryptoExtensions.getJCESensitiveProviderName() : sigProvider;
        this.digestProvider = StringUtils.isEmpty((String)sigProvider) ? CryptoExtensions.getJCEProviderName() : digestProvider;
    }

    @Override
    public CMSSignedData generate(CMSProcessable content) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(content, false, this.sigProvider);
    }

    @Override
    public void addSigner(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = this.getEncOID(key, digestOID);
        this.privateSigners.add(new DirectTargetedSignerInf(key, cert, digestOID, encOID, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(signedAttr), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(unsignedAttr), signedAttr));
    }

    public CMSSignedData generate(String signedContentType, CMSProcessable content, boolean encapsulate, String sigProvider, boolean addDefaultAttributes) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        ContentInfo encInfo;
        boolean isCounterSignature;
        DERObjectIdentifier contentTypeOID;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this._digests.clear();
        if (signedContentType != null) {
            contentTypeOID = new DERObjectIdentifier(signedContentType);
            isCounterSignature = false;
        } else {
            contentTypeOID = CMSObjectIdentifiers.data;
            isCounterSignature = true;
        }
        for (DirectTargetedSignerInf signer : this.privateSigners) {
            try {
                AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(signer.digestOID), (DEREncodable)new DERNull());
                digestAlgs.add((DEREncodable)digAlgId);
                try {
                    signerInfos.add((DEREncodable)signer.toSignerInfo(contentTypeOID, content, this.rand, sigProvider, this.digestProvider, addDefaultAttributes, isCounterSignature));
                }
                catch (ClassCastException e) {
                    signerInfos.add((DEREncodable)signer.toSignerInfo(contentTypeOID, content, this.rand, this.digestProvider, this.digestProvider, addDefaultAttributes, isCounterSignature));
                }
            }
            catch (IOException e) {
                throw new CMSException("encoding error.", (Exception)e);
            }
            catch (InvalidKeyException e) {
                throw new CMSException("key inappropriate for signature.", (Exception)e);
            }
            catch (SignatureException e) {
                throw new CMSException("error creating signature.", (Exception)e);
            }
            catch (CertificateEncodingException e) {
                throw new CMSException("error creating sid.", (Exception)e);
            }
        }
        ASN1Set certificates = null;
        if (this._certs.size() != 0) {
            certificates = SplitProviderDirectSignedDataGenerator.createBerSetFromList(this._certs);
        }
        ASN1Set certrevlist = null;
        if (this._crls.size() != 0) {
            certrevlist = SplitProviderDirectSignedDataGenerator.createBerSetFromList(this._crls);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.write((OutputStream)bOut);
            }
            catch (IOException e) {
                throw new CMSException("encapsulation error.", (Exception)e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(contentTypeOID, (DEREncodable)octs);
        } else {
            encInfo = new ContentInfo(contentTypeOID, null);
        }
        SignedData sd = new SignedData((ASN1Set)new DERSet((DEREncodableVector)digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet((DEREncodableVector)signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)sd);
        return new CMSSignedData(content, contentInfo);
    }

    private static ASN1Set createBerSetFromList(List derObjects) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        Iterator it = derObjects.iterator();
        while (it.hasNext()) {
            v.add((DEREncodable)it.next());
        }
        return new BERSet((DEREncodableVector)v);
    }

    private static class DigOutputStream
    extends OutputStream {
        final MessageDigest dig;

        public DigOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dig.update(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }
    }

    protected class DirectTargetedSignerInf {
        protected final PrivateKey key;
        protected final X509Certificate cert;
        protected final String digestOID;
        protected final String encOID;
        protected final CMSAttributeTableGenerator sAttr;
        protected final CMSAttributeTableGenerator unsAttr;
        protected final AttributeTable baseSignedTable;

        DirectTargetedSignerInf(PrivateKey key, X509Certificate cert, String digestOID, String encOID, CMSAttributeTableGenerator sAttr, CMSAttributeTableGenerator unsAttr, AttributeTable baseSigneTable) {
            this.key = key;
            this.cert = cert;
            this.digestOID = digestOID;
            this.encOID = encOID;
            this.sAttr = sAttr;
            this.unsAttr = unsAttr;
            this.baseSignedTable = baseSigneTable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SignerInfo toSignerInfo(DERObjectIdentifier contentType, CMSProcessable content, SecureRandom random, String sigProvider, String digestProvider, boolean addDefaultAttributes, boolean isCounterSignature) throws IOException, SignatureException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            SignerInfo signerInfo;
            byte[] tmp;
            ASN1Set signedAttr;
            AttributeTable signed;
            AlgorithmIdentifier digAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)new DERNull());
            AlgorithmIdentifier encAlgId = SplitProviderDirectSignedDataGenerator.this.getEncAlgorithmIdentifier(this.encOID);
            String digestName = DigestAlgorithm.fromOID(this.digestOID, DigestAlgorithm.SHA256).getAlgName();
            String signatureName = digestName + "with" + EncryptionAlgorithm.fromOID(this.encOID, EncryptionAlgorithm.RSA).getAlgName();
            Signature sig = Signature.getInstance(signatureName, sigProvider);
            MessageDigest dig = MessageDigest.getInstance(digestName, digestProvider);
            byte[] hash = null;
            if (content != null) {
                content.write((OutputStream)new DigOutputStream(dig));
                hash = dig.digest();
                SplitProviderDirectSignedDataGenerator.this._digests.put(this.digestOID, hash.clone());
            }
            if (addDefaultAttributes) {
                Map parameters = SplitProviderDirectSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
                signed = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            } else {
                signed = this.baseSignedTable;
            }
            if (isCounterSignature) {
                Hashtable ats = signed.toHashtable();
                ats.remove(CMSAttributes.contentType);
                signed = new AttributeTable(ats);
            }
            if ((signedAttr = SplitProviderDirectSignedDataGenerator.this.getAttributeSet(signed)) != null) {
                tmp = signedAttr.getEncoded("DER");
            } else {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try {
                    content.write((OutputStream)bOut);
                    tmp = bOut.toByteArray();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)bOut);
                }
            }
            sig.initSign(this.key, random);
            sig.update(tmp);
            DEROctetString encDigest = new DEROctetString(sig.sign());
            Map parameters = SplitProviderDirectSignedDataGenerator.this.getBaseParameters(contentType, digAlgId, hash);
            parameters.put("encryptedDigest", encDigest.getOctets().clone());
            AttributeTable unsigned = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(parameters)) : null;
            ASN1Set unsignedAttr = SplitProviderDirectSignedDataGenerator.this.getAttributeSet(unsigned);
            ASN1InputStream aIn = null;
            ByteArrayInputStream bIn = null;
            try {
                X509Certificate cert = this.cert;
                bIn = new ByteArrayInputStream(cert.getTBSCertificate());
                aIn = new ASN1InputStream((InputStream)bIn);
                TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)aIn.readObject());
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), tbs.getSerialNumber().getValue());
                signerInfo = new SignerInfo(new SignerIdentifier(encSid), digAlgId, signedAttr, encAlgId, (ASN1OctetString)encDigest, unsignedAttr);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bIn);
                IOUtils.closeQuietly(aIn);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bIn);
            IOUtils.closeQuietly((InputStream)aIn);
            return signerInfo;
        }
    }
}

