/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_addTest
extends BaseKeyStoreManagerCertStoreTest {
    public void testAdd_addNewCert_assertAdded() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getAllCertificates();
            CacheableKeyStoreManagerCertificateStore_addTest.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            CacheableKeyStoreManagerCertificateStore_addTest.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            CacheableKeyStoreManagerCertificateStore_addTest.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }

    public void testAdd_nonMutableStore_assertException() throws Exception {
        if (this.store != null) {
            BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
            this.store.setKeyStoreManager((KeyStoreProtectionManager)mgr);
            boolean exceptionOccured = false;
            try {
                X509CertificateEx user1 = TestUtils.getInternalCert("user1");
                this.store.add((X509Certificate)user1);
            }
            catch (IllegalStateException ex) {
                exceptionOccured = true;
            }
            CacheableKeyStoreManagerCertificateStore_addTest.assertTrue((boolean)exceptionOccured);
        }
    }

    public void testAdd_nonPrivateKeyCert_assertException() throws Exception {
        if (this.store != null) {
            boolean exceptionOccured = false;
            try {
                X509Certificate caCert = TestUtils.getExternalCert("cacert");
                this.store.add(caCert);
            }
            catch (IllegalArgumentException ex) {
                exceptionOccured = true;
            }
            CacheableKeyStoreManagerCertificateStore_addTest.assertTrue((boolean)exceptionOccured);
        }
    }
}

