/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.DirectRecipientInformationFactory;
import org.nhindirect.stagent.cryptography.activekeyops.DirectSignedDataGeneratorFactory;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformationFactory;
import org.nhindirect.stagent.cryptography.activekeyops.SplitProviderDirectSignedDataGeneratorFactory;
import org.nhindirect.stagent.options.OptionsManagerUtils;

public class SMIMECryptographerImpl_constructTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
    }

    public void testContructSMIMECryptographerImpl_defaultSettings() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
        SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA256, (Object)impl.getDigestAlgorithm());
        SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.AES128, (Object)impl.getEncryptionAlgorithm());
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getSignedDataGeneratorFactory() instanceof SplitProviderDirectSignedDataGeneratorFactory));
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getRecipientInformationFactory() instanceof SplitDirectRecipientInformationFactory));
    }

    public void testContructSMIMECryptographerImpl_setAlgorithms() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl(EncryptionAlgorithm.RSA_3DES, DigestAlgorithm.SHA384);
        SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA384, (Object)impl.getDigestAlgorithm());
        SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.RSA_3DES, (Object)impl.getEncryptionAlgorithm());
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getSignedDataGeneratorFactory() instanceof SplitProviderDirectSignedDataGeneratorFactory));
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getRecipientInformationFactory() instanceof SplitDirectRecipientInformationFactory));
    }

    public void testContructSMIMECryptographerImpl_setSigningFactory() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl(EncryptionAlgorithm.RSA_3DES, DigestAlgorithm.SHA384, (DirectSignedDataGeneratorFactory)new SplitProviderDirectSignedDataGeneratorFactory(), null);
        SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA384, (Object)impl.getDigestAlgorithm());
        SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.RSA_3DES, (Object)impl.getEncryptionAlgorithm());
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getSignedDataGeneratorFactory() instanceof SplitProviderDirectSignedDataGeneratorFactory));
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getRecipientInformationFactory() instanceof SplitDirectRecipientInformationFactory));
    }

    public void testContructSMIMECryptographerImpl_setDecFactory() {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl(EncryptionAlgorithm.RSA_3DES, DigestAlgorithm.SHA384, (DirectSignedDataGeneratorFactory)new SplitProviderDirectSignedDataGeneratorFactory(), (DirectRecipientInformationFactory)new SplitDirectRecipientInformationFactory());
        SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA384, (Object)impl.getDigestAlgorithm());
        SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.RSA_3DES, (Object)impl.getEncryptionAlgorithm());
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getSignedDataGeneratorFactory() instanceof SplitProviderDirectSignedDataGeneratorFactory));
        SMIMECryptographerImpl_constructTest.assertTrue((boolean)(impl.getRecipientInformationFactory() instanceof SplitDirectRecipientInformationFactory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContructSMIMECryptographerImpl_JVMSettings() {
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "AES256");
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "SHA256");
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA256, (Object)impl.getDigestAlgorithm());
            SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.AES256, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContructSMIMECryptographerImpl_InvalidJVMSettings() {
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "AES256323");
        System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "SHA2564323");
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA256, (Object)impl.getDigestAlgorithm());
            SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.AES128, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContructSMIMECryptographerImpl_propFileSettings() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm=AES192\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm=SHA512".getBytes());
            outStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        try {
            SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
            SMIMECryptographerImpl_constructTest.assertEquals((Object)DigestAlgorithm.SHA512, (Object)impl.getDigestAlgorithm());
            SMIMECryptographerImpl_constructTest.assertEquals((Object)EncryptionAlgorithm.AES192, (Object)impl.getEncryptionAlgorithm());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.EncryptionAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.cryptographer.smime.DigestAlgorithm", "");
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            propFile.delete();
        }
    }
}

