/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.activekeyops.DirectRecipientInformation;

public class SplitDirectRecipientInformation
extends KeyTransRecipientInformation
implements DirectRecipientInformation {
    protected final String encProvider;
    protected final String keyEncProvider;
    protected final KeyTransRecipientInfo info;

    public SplitDirectRecipientInformation(KeyTransRecipientInfo info, AlgorithmIdentifier encAlg, InputStream data, String encProvider, String keyEncProvider) {
        super(info, encAlg, data);
        this.encProvider = encProvider;
        this.keyEncProvider = keyEncProvider;
        this.info = info;
    }

    @Override
    public byte[] getDecryptedContent(Key key) throws CMSException, NoSuchProviderException {
        return this.getContent(key, this.encProvider);
    }

    public CMSTypedStream getContentStream(Key key, String prov) throws CMSException, NoSuchProviderException {
        byte[] encryptedKey = this.info.getEncryptedKey().getOctets();
        String keyExchangeAlgorithm = this.getExchangeEncryptionAlgorithmName(this._keyEncAlg.getObjectId());
        String alg = EncryptionAlgorithm.fromOID(this._encAlg.getObjectId().getId(), EncryptionAlgorithm.AES128_CBC).getAlgName();
        try {
            SecretKeySpec sKey;
            Cipher keyCipher = Cipher.getInstance(keyExchangeAlgorithm, this.keyEncProvider);
            try {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (GeneralSecurityException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (IllegalStateException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (UnsupportedOperationException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            catch (ProviderException e) {
                keyCipher.init(2, key);
                sKey = new SecretKeySpec(keyCipher.doFinal(encryptedKey), alg);
            }
            return this.getContentFromSessionKey(sKey, this.encProvider);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CMSException("can't find algorithm.", (Exception)e);
        }
        catch (InvalidKeyException e) {
            throw new CMSException("key invalid in message.", (Exception)e);
        }
        catch (NoSuchPaddingException e) {
            throw new CMSException("required padding not supported.", (Exception)e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CMSException("illegal blocksize in message.", (Exception)e);
        }
        catch (BadPaddingException e) {
            throw new CMSException("bad padding in message.", (Exception)e);
        }
    }

    private String getExchangeEncryptionAlgorithmName(DERObjectIdentifier oid) {
        if (PKCSObjectIdentifiers.rsaEncryption.equals((Object)oid)) {
            return "RSA/ECB/PKCS1Padding";
        }
        if (PKCSObjectIdentifiers.id_RSAES_OAEP.equals((Object)oid) && !this.encProvider.equalsIgnoreCase("BC")) {
            return "RSA/ECB/OAEP";
        }
        return oid.getId();
    }
}

