/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.Provider;
import java.security.Security;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsManagerUtils;
import org.nhindirect.stagent.options.OptionsParameter;

public class CryptoExtensions_registerJCEProvidersTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
        OptionsManagerUtils.clearOptionsManagerInstance();
    }

    public void testRegisterJCEProviders_noOptions_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
    }

    public void testRegisterJCEProviders_emptyOptionValue_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER_CLASSES", ""));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
    }

    public void testRegisterJCEProviders_nullOptionValue_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER_CLASSES", null));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
    }

    public void testRegisterJCEProviders_noOptions_providerAlreadyRegistered() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
        int registeredProviderCount = Security.getProviders().length;
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((int)registeredProviderCount, (int)Security.getProviders().length);
    }

    public void testRegisterJCEProviders_singleValidConfiguredProvider_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER_CLASSES", "org.bouncycastle.jce.provider.BouncyCastleProvider"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
    }

    public void testRegisterJCEProviders_singleValidJVMOptionsConfiguredProvider_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        System.clearProperty("org.nhindirect.stagent.cryptography.JCEProviderClassNames");
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderClassNames", "org.bouncycastle.jce.provider.BouncyCastleProvider");
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
        System.clearProperty("org.nhindirect.stagent.cryptography.JCEProviderClassNames");
    }

    public void testRegisterJCEProviders_multipleProviders_providerNotAlreadyRegistered() {
        Security.removeProvider("BC");
        Security.removeProvider("JunitMockProvider");
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER_CLASSES", "org.bouncycastle.jce.provider.BouncyCastleProvider,org.nhindirect.stagent.MockJCEProvider"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider,org.nhindirect.stagent.MockJCEProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("JunitMockProvider"));
        CryptoExtensions.registerJCEProviders();
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"org.bouncycastle.jce.provider.BouncyCastleProvider,org.nhindirect.stagent.MockJCEProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("BC"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)Security.getProvider("JunitMockProvider"));
        Security.removeProvider("JunitMockProvider");
    }

    public void testRegisterJCEProviders_invalidProvider_assertException() {
        Security.removeProvider("BC");
        OptionsManager.getInstance().setOptionsParameter(new OptionsParameter("JCE_PROVIDER_CLASSES", "bogusProvider"));
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"bogusProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
        boolean exceptionOccured = false;
        try {
            CryptoExtensions.registerJCEProviders();
        }
        catch (IllegalStateException e) {
            exceptionOccured = true;
        }
        CryptoExtensions_registerJCEProvidersTest.assertTrue((boolean)exceptionOccured);
        CryptoExtensions_registerJCEProvidersTest.assertNotNull((Object)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES"));
        CryptoExtensions_registerJCEProvidersTest.assertEquals((String)"bogusProvider", (String)OptionsManager.getInstance().getParameter("JCE_PROVIDER_CLASSES").getParamValue());
        CryptoExtensions_registerJCEProvidersTest.assertNull((Object)Security.getProvider("BC"));
    }
}

