/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.nhindirect.policy.PolicyExpression;
import org.nhindirect.policy.PolicyFilter;
import org.nhindirect.policy.PolicyProcessException;
import org.nhindirect.policy.PolicyRequiredException;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.policy.PolicyResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;

public class DefaultNHINDAgent_filterCertificateByPolicyTest
extends TestCase {
    public void testFilterCertificateByPolicy_nullResolver_assertNoCertsFiltered() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), null, certs, true);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)1, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_noIncomingExpressions_assertNoCertsFiltered() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, true);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)1, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_noOutgoingExpressions_assertNoCertsFiltered() throws Exception {
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getOutgoingPolicy((InternetAddress)Matchers.any())).thenReturn(new ArrayList());
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, false);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)1, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_incomingPolicyCompliant_assertNoCertsFiltered() throws Exception {
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        Mockito.when((Object)filter.isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any())).thenReturn((Object)true);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(expression));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        agent.setPolicyFilter(filter);
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, true);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)1, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_outgoingPolicyCompliant_assertNoCertsFiltered() throws Exception {
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        Mockito.when((Object)filter.isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any())).thenReturn((Object)true);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getOutgoingPolicy((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(expression));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        agent.setPolicyFilter(filter);
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, false);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)1, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_notCompliant_assertNoCertsFiltered() throws Exception {
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        Mockito.when((Object)filter.isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any())).thenReturn((Object)false);
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(expression));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        agent.setPolicyFilter(filter);
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, true);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)0, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_requiredFieldMissing_assertNoCertsFiltered() throws Exception {
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable)new PolicyRequiredException("Just Passing Through")).when((Object)filter)).isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any());
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(expression));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        agent.setPolicyFilter(filter);
        Collection filteredCerts = agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, true);
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertEquals((int)0, (int)filteredCerts.size());
    }

    public void testFilterCertificateByPolicy_badPolicyExpression_assertNoCertsFiltered() throws Exception {
        PolicyFilter filter = (PolicyFilter)Mockito.mock(PolicyFilter.class);
        ((PolicyFilter)Mockito.doThrow((Throwable)new PolicyProcessException("Just Passing Through")).when((Object)filter)).isCompliant((X509Certificate)Matchers.any(), (PolicyExpression)Matchers.any());
        PolicyExpression expression = (PolicyExpression)Mockito.mock(PolicyExpression.class);
        X509Certificate cert = (X509Certificate)Mockito.mock(X509Certificate.class);
        List<X509Certificate> certs = Arrays.asList(cert);
        PolicyResolver resolver = (PolicyResolver)Mockito.mock(PolicyResolver.class);
        Mockito.when((Object)resolver.getIncomingPolicy((InternetAddress)Matchers.any())).thenReturn(Arrays.asList(expression));
        DefaultNHINDAgent agent = new DefaultNHINDAgent("", (CertificateResolver)Mockito.mock(CertificateResolver.class), (CertificateResolver)Mockito.mock(CertificateResolver.class), (TrustAnchorResolver)Mockito.mock(TrustAnchorResolver.class));
        agent.setPolicyFilter(filter);
        boolean exceptionOccured = false;
        try {
            agent.filterCertificatesByPolicy(new InternetAddress("me@you.com"), resolver, certs, true);
        }
        catch (AgentException e) {
            exceptionOccured = true;
        }
        DefaultNHINDAgent_filterCertificateByPolicyTest.assertTrue((boolean)exceptionOccured);
    }
}

