/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.lang.ref.SoftReference;
import java.security.cert.X509CRL;
import java.util.Calendar;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;

public class CRLRevocationManager_getCRLCollectionTest
extends TestCase {
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    public void testGetCRLCollection_emptyCRL_assertEmpty() {
        CRLRevocationManager_getCRLCollectionTest.assertEquals((int)0, (int)CRLRevocationManager.getInstance().getCRLCollection().size());
    }

    public void testGetCRLCollection_singleCRL_assertCRLRetrieved() {
        String uri = "http://localhost:8080/master.crl";
        Calendar nextUpdateDate = Calendar.getInstance();
        nextUpdateDate.set(1, nextUpdateDate.get(1) + 10);
        X509CRL crl = (X509CRL)Mockito.mock(X509CRL.class);
        Mockito.when((Object)crl.getNextUpdate()).thenReturn((Object)nextUpdateDate.getTime());
        CRLRevocationManager.cache.put(uri, new SoftReference<X509CRL>(crl));
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCRLCollectionTest.assertNotNull((Object)retCrl);
        CRLRevocationManager_getCRLCollectionTest.assertEquals((Object)crl, (Object)retCrl);
        CRLRevocationManager_getCRLCollectionTest.assertEquals((int)1, (int)CRLRevocationManager.getInstance().getCRLCollection().size());
    }

    public void testGetCRLCollection_singleCRL_softRefExpired_assertEmpty() {
        String uri = "http://localhost:8080/master.crl";
        SoftReference softRef = (SoftReference)Mockito.mock(SoftReference.class);
        Mockito.when(softRef.get()).thenReturn(null);
        CRLRevocationManager.cache.put(uri, softRef);
        CRLRevocationManager_getCRLCollectionTest.assertEquals((int)0, (int)CRLRevocationManager.getInstance().getCRLCollection().size());
    }
}

