/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import junit.framework.TestCase;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;

public class CRLRevocationManager_getCacheFileNameTest
extends TestCase {
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    public void testGetCacheName_uniqueNames() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        CRLRevocationManager_getCacheFileNameTest.assertNotNull((Object)uriName1);
        CRLRevocationManager_getCacheFileNameTest.assertTrue((boolean)uriName1.contains("CrlCache"));
        String uriName2 = CRLRevocationManager.getCacheFileName((String)"http://localhost/master.crl");
        CRLRevocationManager_getCacheFileNameTest.assertNotNull((Object)uriName2);
        CRLRevocationManager_getCacheFileNameTest.assertTrue((boolean)uriName2.contains("CrlCache"));
        CRLRevocationManager_getCacheFileNameTest.assertFalse((boolean)uriName1.equals(uriName2));
    }

    public void testGetCacheName_sameNames() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        CRLRevocationManager_getCacheFileNameTest.assertNotNull((Object)uriName1);
        CRLRevocationManager_getCacheFileNameTest.assertTrue((boolean)uriName1.contains("CrlCache"));
        String uriName2 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        CRLRevocationManager_getCacheFileNameTest.assertNotNull((Object)uriName2);
        CRLRevocationManager_getCacheFileNameTest.assertTrue((boolean)uriName2.contains("CrlCache"));
        CRLRevocationManager_getCacheFileNameTest.assertEquals((String)uriName1, (String)uriName2);
    }

    public void testGetCacheName_nullCacheLocation_assertEmptyName() throws Exception {
        String uriName1 = CRLRevocationManager.getCacheFileName((String)"http://localhost:8080/master.crl");
        CRLRevocationManager_getCacheFileNameTest.assertNotNull((Object)uriName1);
        CRLRevocationManager_getCacheFileNameTest.assertEquals((String)"", (String)uriName1);
    }
}

