/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.CertStoreCachePolicy;
import org.nhindirect.stagent.cert.CertificateStore;
import org.nhindirect.stagent.cert.impl.DNSCertificateStore;
import org.xbill.DNS.ResolverConfig;

public class DNSCertificateStore_constructTest
extends TestCase {
    public void setUp() {
        CertCacheFactory.getInstance().flushAll();
    }

    public void tearDown() {
        CertCacheFactory.getInstance().flushAll();
    }

    public void testContructDNSCertificateStore_defaultConstructor() {
        DNSCertificateStore store = new DNSCertificateStore();
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_nullServers() {
        DNSCertificateStore store = new DNSCertificateStore(null);
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_emptyServers() {
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList());
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_providedServers() {
        List<String> servers = Arrays.asList("159.140.168.3");
        DNSCertificateStore store = new DNSCertificateStore(servers);
        DNSCertificateStore_constructTest.assertEquals((int)1, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertEquals((String)"159.140.168.3", (String)((String)store.servers.iterator().next()));
        DNSCertificateStore_constructTest.assertNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_fullConstructor_nullBootStrap() {
        DNSCertificateStore store = new DNSCertificateStore(null, null, null);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
        DNSCertificateStore_constructTest.assertNull((Object)store.localStoreDelegate);
    }

    public void testContructDNSCertificateStore_fullConstructor_providedServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        List<String> servers = Arrays.asList("159.140.168.3");
        DNSCertificateStore store = new DNSCertificateStore(servers, bootStrap, null);
        DNSCertificateStore_constructTest.assertEquals((int)1, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertEquals((String)"159.140.168.3", (String)((String)store.servers.iterator().next()));
        DNSCertificateStore_constructTest.assertEquals((Object)bootStrap, (Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_fullConstructor_nullServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        DNSCertificateStore store = new DNSCertificateStore(null, bootStrap, null);
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNotNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_fullConstructor_emptyServers() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList(), bootStrap, null);
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNotNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertNotNull((Object)store.cachePolicy);
    }

    public void testContructDNSCertificateStore_fullConstructor_emptyServersAndProvidedCachePolicy() {
        CertificateStore bootStrap = (CertificateStore)Mockito.mock(CertificateStore.class);
        CertStoreCachePolicy cachePolicy = (CertStoreCachePolicy)Mockito.mock(CertStoreCachePolicy.class);
        DNSCertificateStore store = new DNSCertificateStore(new ArrayList(), bootStrap, cachePolicy);
        DNSCertificateStore_constructTest.assertEquals((int)ResolverConfig.getCurrentConfig().servers().length, (int)store.servers.size());
        DNSCertificateStore_constructTest.assertNotNull((Object)store.localStoreDelegate);
        DNSCertificateStore_constructTest.assertEquals((Object)cachePolicy, (Object)store.cachePolicy);
    }
}

