/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.CryptoAlgorithmsHelper;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.DirectSignedDataGeneratorFactory;
import org.nhindirect.stagent.cryptography.activekeyops.SplitProviderDirectSignedDataGeneratorFactory;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.TestUtils;

public class SMIMECryptographerImpl_createSignatureEntityTest
extends TestCase {
    protected String pkcs11ProvName;

    public void setUp() throws Exception {
        CryptoExtensions.registerJCEProviders();
    }

    protected MimeEntity contentToMimeEntity(BodyPart part) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        part.writeTo((OutputStream)bos);
        bos.flush();
        ByteArrayInputStream stream = new ByteArrayInputStream(bos.toByteArray());
        return new MimeEntity((InputStream)stream);
    }

    public void testCreateSignatureEntity_defaultSigGenerator_assertEntityCreated() throws Exception {
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeEntity ent = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())).extractEntityForSignature(true);
        byte[] bytesToSign = EntitySerializer.Default.serializeToBytes((MimePart)ent);
        X509Certificate sigCertBPrivate = TestUtils.loadCertificate("certCheckB.p12");
        MimeMultipart mm = impl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
        SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)mm);
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)2, (int)mm.getCount());
        this.validatedSignatureHeaders(mm);
        this.validateSignature(this.deserializeSignatureEnvelope(mm), sigCertBPrivate);
    }

    public void testCreateSignatureEntity_difSigAndDigestGenerators_assertEntityCreatedAndMatchesControl() throws Exception {
        SplitProviderDirectSignedDataGeneratorFactory factory = new SplitProviderDirectSignedDataGeneratorFactory("SunRsaSign", "BC");
        SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
        impl.setSignedDataGeneratorFactory((DirectSignedDataGeneratorFactory)factory);
        String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
        MimeEntity ent = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())).extractEntityForSignature(true);
        byte[] bytesToSign = EntitySerializer.Default.serializeToBytes((MimePart)ent);
        X509Certificate sigCertBPrivate = TestUtils.loadCertificate("certCheckB.p12");
        MimeMultipart mm = impl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
        SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)mm);
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)2, (int)mm.getCount());
        this.validatedSignatureHeaders(mm);
        SMIMECryptographerImpl controllImpl = new SMIMECryptographerImpl();
        MimeMultipart controllmm = controllImpl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
        SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)controllmm);
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)2, (int)controllmm.getCount());
        MimeEntity signedContent = this.contentToMimeEntity(mm.getBodyPart(1));
        MimeEntity controlSignedContent = this.contentToMimeEntity(controllmm.getBodyPart(1));
        SMIMECryptographerImpl_createSignatureEntityTest.assertTrue((boolean)Arrays.equals(signedContent.getContentAsBytes(), controlSignedContent.getContentAsBytes()));
        this.validateSignature(this.deserializeSignatureEnvelope(mm), sigCertBPrivate);
        this.validateSignature(this.deserializeSignatureEnvelope(controllmm), sigCertBPrivate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateSignatureEntity_hsmSignatureGenerator_assertEntityCreatedAndMatchesControl() throws Exception {
        String installedAlias = "JunitTestKey";
        this.pkcs11ProvName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((String)this.pkcs11ProvName)) {
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            try {
                ks.deleteEntry("JunitTestKey");
            }
            catch (Exception e) {
                // empty catch block
            }
            X509CertificateEx sigCertBPrivate = (X509CertificateEx)TestUtils.loadCertificate("certCheckB.p12");
            try {
                ks.setKeyEntry("JunitTestKey", sigCertBPrivate.getPrivateKey(), null, new Certificate[]{sigCertBPrivate});
                KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)ks.getEntry("JunitTestKey", null);
                X509CertificateEx signerCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)entry.getCertificate()), (PrivateKey)entry.getPrivateKey());
                SplitProviderDirectSignedDataGeneratorFactory factory = new SplitProviderDirectSignedDataGeneratorFactory(this.pkcs11ProvName, "BC");
                SMIMECryptographerImpl impl = new SMIMECryptographerImpl();
                impl.setSignedDataGeneratorFactory((DirectSignedDataGeneratorFactory)factory);
                String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
                MimeEntity ent = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes())).extractEntityForSignature(true);
                byte[] bytesToSign = EntitySerializer.Default.serializeToBytes((MimePart)ent);
                MimeMultipart mm = impl.createSignatureEntity(bytesToSign, Arrays.asList(signerCert));
                SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)mm);
                SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)2, (int)mm.getCount());
                this.validatedSignatureHeaders(mm);
                SMIMECryptographerImpl controllImpl = new SMIMECryptographerImpl();
                MimeMultipart controllmm = controllImpl.createSignatureEntity(bytesToSign, Arrays.asList(sigCertBPrivate));
                SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)controllmm);
                SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)2, (int)controllmm.getCount());
                this.validateSignature(this.deserializeSignatureEnvelope(mm), (X509Certificate)sigCertBPrivate);
                this.validateSignature(this.deserializeSignatureEnvelope(controllmm), (X509Certificate)sigCertBPrivate);
            }
            finally {
                ks.deleteEntry("JunitTestKey");
            }
        }
    }

    protected void validateSignature(CMSSignedData data, X509Certificate signerCert) throws Exception {
        SMIMECryptographerImpl_createSignatureEntityTest.assertNotNull((Object)data);
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((int)1, (int)data.getSignerInfos().getSigners().size());
        for (SignerInformation sigInfo : data.getSignerInfos().getSigners()) {
            SMIMECryptographerImpl_createSignatureEntityTest.assertTrue((boolean)sigInfo.verify(signerCert, CryptoExtensions.getJCEProviderName()));
            SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((String)DigestAlgorithm.SHA256.getOID(), (String)sigInfo.getDigestAlgOID());
        }
    }

    protected void validatedSignatureHeaders(MimeMultipart mm) throws Exception {
        ContentType type = new ContentType(mm.getContentType());
        SMIMECryptographerImpl_createSignatureEntityTest.assertTrue((boolean)type.match("multipart/signed"));
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((String)"application/pkcs7-signature", (String)type.getParameter("protocol"));
        SMIMECryptographerImpl_createSignatureEntityTest.assertEquals((String)CryptoAlgorithmsHelper.toDigestAlgorithmMicalg((DigestAlgorithm)DigestAlgorithm.SHA256), (String)type.getParameter("micalg"));
        ContentType signedTypetype = new ContentType(mm.getBodyPart(1).getContentType());
        SMIMECryptographerImpl_createSignatureEntityTest.assertTrue((boolean)signedTypetype.match("application/pkcs7-signature"));
    }

    protected CMSSignedData deserializeSignatureEnvelope(MimeMultipart mm) throws Exception {
        MimeEntity contentEntity = this.contentToMimeEntity(mm.getBodyPart(0));
        byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)contentEntity);
        MimeBodyPart signedContent = null;
        signedContent = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
        return new CMSSignedData((CMSProcessable)new CMSProcessableBodyPart((BodyPart)signedContent), mm.getBodyPart(1).getInputStream());
    }
}

