/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.security.Key;
import java.util.Arrays;
import javax.mail.internet.MimeBodyPart;
import junit.framework.TestCase;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformation;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformationFactory;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.utils.TestUtils;

public class DefaultDirectRecipientInformation_getDecryptedContentTest
extends TestCase {
    protected X509CertificateEx encCert;

    protected SMIMEEnveloped createSMIMEEnv() throws Exception {
        this.encCert = TestUtils.getInternalCert("user1");
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SMIMECryptographerImpl encryptor = new SMIMECryptographerImpl();
        return new SMIMEEnveloped((MimeBodyPart)encryptor.encrypt(entity, Arrays.asList(this.encCert)));
    }

    public void testDecryptedContent_defaultConfig_assertDecrypted() throws Exception {
        SMIMEEnveloped env = this.createSMIMEEnv();
        RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory();
        SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
        DefaultDirectRecipientInformation_getDecryptedContentTest.assertNotNull((Object)recInfo.getDecryptedContent((Key)this.encCert.getPrivateKey()));
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

