/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.mail.internet.MimeBodyPart;
import junit.framework.TestCase;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.mail.smime.SMIMEEnveloped;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformation;
import org.nhindirect.stagent.cryptography.activekeyops.SplitDirectRecipientInformationFactory;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.utils.TestUtils;

public class SplitDirectRecipientInformationFactory_createInstanceTest
extends TestCase {
    protected SMIMEEnveloped createSMIMEEnv() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SMIMECryptographerImpl encryptor = new SMIMECryptographerImpl();
        return new SMIMEEnveloped((MimeBodyPart)encryptor.encrypt(entity, Arrays.asList(cert)));
    }

    public void testInstanceTest_emptyProvider_assertDefaultProvider() throws Exception {
        SMIMEEnveloped env = this.createSMIMEEnv();
        RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory();
        SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
        SplitDirectRecipientInformationFactory_createInstanceTest.assertEquals((String)CryptoExtensions.getJCEProviderName(), (String)recInfo.encProvider);
        SplitDirectRecipientInformationFactory_createInstanceTest.assertEquals((String)CryptoExtensions.getJCESensitiveProviderName(), (String)recInfo.keyEncProvider);
    }

    public void testInstanceTest_configedProvider_assertConfigedProvider() throws Exception {
        SMIMEEnveloped env = this.createSMIMEEnv();
        RecipientInformation recipient = (RecipientInformation)env.getRecipientInfos().getRecipients().iterator().next();
        SplitDirectRecipientInformationFactory factory = new SplitDirectRecipientInformationFactory("SensitiveProv", "NonSenProv");
        SplitDirectRecipientInformation recInfo = (SplitDirectRecipientInformation)factory.createInstance(recipient, env);
        SplitDirectRecipientInformationFactory_createInstanceTest.assertEquals((String)"NonSenProv", (String)recInfo.encProvider);
        SplitDirectRecipientInformationFactory_createInstanceTest.assertEquals((String)"SensitiveProv", (String)recInfo.keyEncProvider);
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

