/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography.activekeyops;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.mail.smime.CMSProcessableBodyPart;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.activekeyops.DirectSignedDataGenerator;
import org.nhindirect.stagent.cryptography.activekeyops.SplitProviderDirectSignedDataGenerator;
import org.nhindirect.stagent.utils.TestUtils;

public class SplitProviderDirectSignedDataGenerator_generateTest
extends TestCase {
    protected X509Certificate signerCert;
    protected String pkcs11ProvName;

    protected void setupSigningInfo(DirectSignedDataGenerator gen) throws Exception {
        ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
        SMIMECapabilityVector caps = new SMIMECapabilityVector();
        caps.addCapability(SMIMECapability.dES_EDE3_CBC);
        caps.addCapability(SMIMECapability.rC2_CBC, 128);
        caps.addCapability(SMIMECapability.dES_CBC);
        caps.addCapability(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
        caps.addCapability(SMIMECryptographerImpl.x509CertificateObjectsIdent);
        signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
        if (this.signerCert == null) {
            this.signerCert = TestUtils.getInternalCert("user1");
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        gen.addSigner(((X509CertificateEx)this.signerCert).getPrivateKey(), this.signerCert, DigestAlgorithm.SHA256.getOID(), SMIMECryptographerImpl.createAttributeTable((ASN1EncodableVector)signedAttrs), null);
        certList.add(this.signerCert);
        CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), CryptoExtensions.getJCEProviderNameForTypeAndAlgorithm((String)"CertStore", (String)"Collection"));
        gen.addCertificatesAndCRLs(certsAndcrls);
    }

    protected void validateSignature(CMSSignedData data) throws Exception {
        SplitProviderDirectSignedDataGenerator_generateTest.assertNotNull((Object)data);
        SplitProviderDirectSignedDataGenerator_generateTest.assertEquals((int)1, (int)data.getSignerInfos().getSigners().size());
        for (SignerInformation sigInfo : data.getSignerInfos().getSigners()) {
            SplitProviderDirectSignedDataGenerator_generateTest.assertTrue((boolean)sigInfo.verify(this.signerCert, CryptoExtensions.getJCEProviderName()));
        }
    }

    public void testGenerate_sameDefaultSigAndDigestProvider_assertGenerated() throws Exception {
        SplitProviderDirectSignedDataGenerator gen = new SplitProviderDirectSignedDataGenerator("", "");
        this.setupSigningInfo((DirectSignedDataGenerator)gen);
        MimeBodyPart signedContent = new MimeBodyPart();
        signedContent.addHeader("To:", "me@you.com");
        signedContent.addHeader("From", "test.test.com");
        signedContent.setText("Some Text To Sign");
        CMSProcessableBodyPart content = new CMSProcessableBodyPart((BodyPart)signedContent);
        CMSSignedData signedData = gen.generate((CMSProcessable)content);
        this.validateSignature(signedData);
    }

    public void testGenerate_differentDefaultSigAndDigestProvider_assertGenerated() throws Exception {
        SplitProviderDirectSignedDataGenerator gen = new SplitProviderDirectSignedDataGenerator("SunRsaSign", "BC");
        this.setupSigningInfo((DirectSignedDataGenerator)gen);
        MimeBodyPart signedContent = new MimeBodyPart();
        signedContent.addHeader("To:", "me@you.com");
        signedContent.addHeader("From", "test.test.com");
        signedContent.setText("Some Text To Sign");
        CMSProcessableBodyPart content = new CMSProcessableBodyPart((BodyPart)signedContent);
        CMSSignedData signedData = gen.generate((CMSProcessable)content);
        this.validateSignature(signedData);
    }

    public void testGenerate_safeNetHSMSignatureProvider_assertGenerated() throws Exception {
        this.pkcs11ProvName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((String)this.pkcs11ProvName)) {
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                KeyStore.Entry entry = ks.getEntry(alias, null);
                if (!(entry instanceof KeyStore.PrivateKeyEntry)) continue;
                KeyStore.PrivateKeyEntry ent = (KeyStore.PrivateKeyEntry)entry;
                this.signerCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)ent.getCertificate()), (PrivateKey)ent.getPrivateKey());
                break;
            }
            SplitProviderDirectSignedDataGenerator gen = new SplitProviderDirectSignedDataGenerator(this.pkcs11ProvName, "BC");
            this.setupSigningInfo((DirectSignedDataGenerator)gen);
            MimeBodyPart signedContent = new MimeBodyPart();
            signedContent.addHeader("To:", "me@you.com");
            signedContent.addHeader("From", "test.test.com");
            signedContent.setText("Some Text To Sign");
            CMSProcessableBodyPart content = new CMSProcessableBodyPart((BodyPart)signedContent);
            CMSSignedData signedData = gen.generate((CMSProcessable)content);
            this.validateSignature(signedData);
        }
    }

    static {
        CryptoExtensions.registerJCEProviders();
    }
}

