/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.NHINDStandard;
import org.nhindirect.stagent.OutgoingMessage;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.WrappedMessage;
import org.nhindirect.stagent.utils.TestUtils;

public class WrappedMessageTest
extends TestCase {
    public void testCopyNHINDStandard_assertPromotedCCHeaders() throws Exception {
        Message msg = new Message();
        String msgId = UUID.randomUUID().toString();
        msg.addHeader("message-id", msgId);
        msg.addHeader("cc", "test@testdomain.com, gm2552@cerner.com");
        msg.addHeader("MIME-Version", "1.0");
        msg.setContent((Object)"SomeText", "text/plain");
        Message wrappedMessage = WrappedMessage.create((Message)msg, (String[])NHINDStandard.MailHeadersUsed);
        String ccHeader = wrappedMessage.getHeader("cc", ",");
        WrappedMessageTest.assertNotNull((Object)ccHeader);
        WrappedMessageTest.assertEquals((String)"test@testdomain.com, gm2552@cerner.com", (String)ccHeader);
    }

    public void testCopyNHINDStandard_fromFullMessage_assertPromotedCCHeaders() throws Exception {
        String testMessage = TestUtils.readResource("CCTestMessage.txt");
        Message msg = new Message((InputStream)new ByteArrayInputStream(testMessage.getBytes("ASCII")));
        Message wrappedMessage = WrappedMessage.create((Message)msg, (String[])NHINDStandard.MailHeadersUsed);
        String ccHeader = wrappedMessage.getHeader("cc", ",");
        WrappedMessageTest.assertNotNull((Object)ccHeader);
        WrappedMessageTest.assertEquals((String)"User1@Cerner.com, gm2552@cerner.com", (String)ccHeader);
    }

    public void testCopyNHINDStandard_encyrptMessage_assertPromotedInvalidCCHeaders() throws Exception {
        DefaultNHINDAgent agent = TestUtils.getStockAgent(Arrays.asList("cerner.com"));
        String testMessage = TestUtils.readResource("CCTestMessage.txt");
        OutgoingMessage SMIMEenvMessage = agent.processOutgoing(testMessage);
        String ccHeader = SMIMEenvMessage.getMessage().getHeader("cc", ",");
        WrappedMessageTest.assertNotNull((Object)ccHeader);
        WrappedMessageTest.assertEquals((String)"User1@Cerner.com", (String)ccHeader);
    }
}

