/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager_getParamTest
extends TestCase {
    public void setUp() {
        OptionsManager.INSTANCE = null;
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    public void testGetParams_emptyParams() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_getParamTest.assertEquals((int)0, (int)mgr.getParameters().size());
    }

    public void testGetParams_overrideExistantParam() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_getParamTest.assertNull((Object)mgr.getParameter("Test Param"));
        OptionsParameter param = new OptionsParameter("Test Param", "Test Value");
        mgr.setOptionsParameter(param);
        OptionsManager_getParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("Test Param");
        OptionsManager_getParamTest.assertNotNull((Object)retParam);
        OptionsManager_getParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_getParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        param = new OptionsParameter("Test Param", "Test Value2");
        mgr.setOptionsParameter(param);
        OptionsManager_getParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        retParam = mgr.getParameter("Test Param");
        OptionsManager_getParamTest.assertNotNull((Object)retParam);
        OptionsManager_getParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_getParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
    }

    public void testGetParams_overrideJVMParam() throws Exception {
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "BC");
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_getParamTest.assertNotNull((Object)"JCE_PROVIDER");
        OptionsParameter param = new OptionsParameter("JCE_PROVIDER", "NSS");
        mgr.setOptionsParameter(param);
        OptionsManager_getParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("JCE_PROVIDER");
        OptionsManager_getParamTest.assertNotNull((Object)retParam);
        OptionsManager_getParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_getParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
    }

    public void testGetParams_nullParameter_assertException() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        boolean exceptionOccured = false;
        try {
            mgr.getParameter(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        OptionsManager_getParamTest.assertTrue((boolean)exceptionOccured);
    }

    public void testGetParams_emptyParameter_assertException() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        boolean exceptionOccured = false;
        try {
            mgr.getParameter("");
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        OptionsManager_getParamTest.assertTrue((boolean)exceptionOccured);
    }
}

