/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsManager;

public class OptionsManager_initTest
extends TestCase {
    public void setUp() {
        OptionsManager.INSTANCE = null;
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    public void testInit_noParamsSet() throws Exception {
        OptionsManager manager = OptionsManager.getInstance();
        OptionsManager_initTest.assertEquals((int)0, (int)manager.options.size());
    }

    public void testInit_noUnknownParam() throws Exception {
        OptionsManager manager = OptionsManager.getInstance();
        manager.initParam("Bogus Param Name");
        OptionsManager_initTest.assertEquals((int)0, (int)manager.options.size());
    }

    public void testInit_emptyParamValue() throws Exception {
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
        OptionsManager manager = OptionsManager.getInstance();
        OptionsManager_initTest.assertEquals((int)0, (int)manager.options.size());
    }

    public void testInit_populateParamValue() throws Exception {
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "BC");
        OptionsManager manager = OptionsManager.getInstance();
        OptionsManager_initTest.assertEquals((int)1, (int)manager.options.size());
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
    }
}

