/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager_loadParamsFromPropertiesFileTest
extends TestCase {
    public void setUp() {
        OptionsManager.destroyInstance();
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testloadParamsFromPropertiesFile_defaultPropertiesFile() throws Exception {
        File propFile = new File("agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptography.JCEProviderName=SC".getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        try {
            OptionsManager_loadParamsFromPropertiesFileTest.assertEquals((String)"SC", (String)param.getParamValue());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
            propFile.delete();
        }
    }

    public void testloadParamsFromPropertiesFile_defaultPropertiesFile_fileDoesNotExist() throws Exception {
        File propFile = new File("agentSettings.properties");
        OptionsManager_loadParamsFromPropertiesFileTest.assertFalse((boolean)propFile.exists());
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        OptionsManager_loadParamsFromPropertiesFileTest.assertNull((Object)param);
    }

    public void testloadParamsFromPropertiesFile_customPropertiesFile_fileDoesNotExist() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        OptionsManager_loadParamsFromPropertiesFileTest.assertNull((Object)param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testloadParamsFromPropertiesFile_customPropertiesFile() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        FileOutputStream outStream = null;
        String jvmPropValue = UUID.randomUUID().toString();
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            String value = "org.nhindirect.stagent.cryptography.JCEProviderName=" + jvmPropValue;
            ((OutputStream)outStream).write(value.getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        try {
            OptionsManager_loadParamsFromPropertiesFileTest.assertEquals((String)jvmPropValue, (String)param.getParamValue());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
            propFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testloadParamsFromPropertiesFile_customPropertiesFile_paramIsNotAKnownJVMProp() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        FileOutputStream outStream = null;
        String jvmPropValue = UUID.randomUUID().toString();
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            String value = "testProperty=" + jvmPropValue;
            ((OutputStream)outStream).write(value.getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        OptionsParameter param = OptionsManager.getInstance().getParameter("testProperty");
        try {
            OptionsManager_loadParamsFromPropertiesFileTest.assertEquals((String)jvmPropValue, (String)param.getParamValue());
        }
        finally {
            System.setProperty("testProperty", "");
            System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
            propFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testloadParamsFromPropertiesFile_defaultPropertiesFile_JVMOverridesProperty() throws Exception {
        File propFile = new File("agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            ((OutputStream)outStream).write("org.nhindirect.stagent.cryptography.JCEProviderName=SC".getBytes());
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        String jvmPropValue = UUID.randomUUID().toString();
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", jvmPropValue);
        OptionsParameter param = OptionsManager.getInstance().getParameter("JCE_PROVIDER");
        try {
            OptionsManager_loadParamsFromPropertiesFileTest.assertEquals((String)jvmPropValue, (String)param.getParamValue());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
            propFile.delete();
        }
    }
}

