/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsManager;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsManager_setParamTest
extends TestCase {
    public void setUp() {
        OptionsManager.INSTANCE = null;
    }

    public void tearDown() {
        OptionsManager.getInstance().options.clear();
    }

    public void testSetParams_emptyParams_setNonExistantParam() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamTest.assertNull((Object)mgr.getParameter("Test Param"));
        OptionsManager_setParamTest.assertEquals((int)0, (int)mgr.getParameters().size());
        OptionsParameter param = new OptionsParameter("Test Param", "Test Value");
        mgr.setOptionsParameter(param);
        OptionsManager_setParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("Test Param");
        OptionsManager_setParamTest.assertNotNull((Object)retParam);
        OptionsManager_setParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
    }

    public void testSetParams_overrideExistantParam() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamTest.assertNull((Object)mgr.getParameter("Test Param"));
        OptionsParameter param = new OptionsParameter("Test Param", "Test Value");
        mgr.setOptionsParameter(param);
        OptionsManager_setParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("Test Param");
        OptionsManager_setParamTest.assertNotNull((Object)retParam);
        OptionsManager_setParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        param = new OptionsParameter("Test Param", "Test Value2");
        mgr.setOptionsParameter(param);
        OptionsManager_setParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        retParam = mgr.getParameter("Test Param");
        OptionsManager_setParamTest.assertNotNull((Object)retParam);
        OptionsManager_setParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
    }

    public void testSetParams_overrideJVMParam() throws Exception {
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "BC");
        OptionsManager mgr = OptionsManager.getInstance();
        OptionsManager_setParamTest.assertNotNull((Object)"JCE_PROVIDER");
        OptionsParameter param = new OptionsParameter("JCE_PROVIDER", "NSS");
        mgr.setOptionsParameter(param);
        OptionsManager_setParamTest.assertEquals((int)1, (int)mgr.getParameters().size());
        OptionsParameter retParam = mgr.getParameter("JCE_PROVIDER");
        OptionsManager_setParamTest.assertNotNull((Object)retParam);
        OptionsManager_setParamTest.assertEquals((String)param.getParamName(), (String)retParam.getParamName());
        OptionsManager_setParamTest.assertEquals((String)param.getParamValue(), (String)retParam.getParamValue());
        System.setProperty("org.nhindirect.stagent.cryptography.JCEProviderName", "");
    }

    public void testSetParams_nullParameter_assertException() throws Exception {
        OptionsManager mgr = OptionsManager.getInstance();
        boolean exceptionOccured = false;
        try {
            mgr.setOptionsParameter(null);
        }
        catch (IllegalArgumentException e) {
            exceptionOccured = true;
        }
        OptionsManager_setParamTest.assertTrue((boolean)exceptionOccured);
    }
}

