/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.options;

import java.security.SecureRandom;
import junit.framework.TestCase;
import org.nhindirect.stagent.options.OptionsParameter;

public class OptionsParameter_getParamValueAsIntegerTest
extends TestCase {
    public void testGetParamValueAsInteger_nullParam_returnDefaultVal() {
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        int defaultVal = random.nextInt();
        int retVal = OptionsParameter.getParamValueAsInteger(null, (int)defaultVal);
        OptionsParameter_getParamValueAsIntegerTest.assertEquals((int)defaultVal, (int)retVal);
    }

    public void testGetParamValueAsInteger_nullParamValue_returnDefaultVal() {
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        int defaultVal = random.nextInt();
        int retVal = OptionsParameter.getParamValueAsInteger((OptionsParameter)new OptionsParameter("test", null), (int)defaultVal);
        OptionsParameter_getParamValueAsIntegerTest.assertEquals((int)defaultVal, (int)retVal);
    }

    public void testGetParamValueAsInteger_emptyParamValue_returnDefaultVal() {
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        int defaultVal = random.nextInt();
        int retVal = OptionsParameter.getParamValueAsInteger((OptionsParameter)new OptionsParameter("test", ""), (int)defaultVal);
        OptionsParameter_getParamValueAsIntegerTest.assertEquals((int)defaultVal, (int)retVal);
    }

    public void testGetParamValueAsInteger_invalidIntFormat_returnDefaultVal() {
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        int defaultVal = random.nextInt();
        int retVal = OptionsParameter.getParamValueAsInteger((OptionsParameter)new OptionsParameter("test", "i-/ekux"), (int)defaultVal);
        OptionsParameter_getParamValueAsIntegerTest.assertEquals((int)defaultVal, (int)retVal);
    }

    public void testGetParamValueAsInteger_validValue_returnValue() {
        SecureRandom random = new SecureRandom();
        random.setSeed(System.currentTimeMillis());
        int defaultVal = random.nextInt();
        int retVal = OptionsParameter.getParamValueAsInteger((OptionsParameter)new OptionsParameter("test", "5"), (int)defaultVal);
        OptionsParameter_getParamValueAsIntegerTest.assertEquals((int)5, (int)retVal);
    }
}

