/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.mail.smime.CMSProcessableBodyPartInbound;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.CryptoExtensions;
import org.nhindirect.stagent.DefaultMessageSignatureImpl;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.TrustModel;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustModel_EnforceIncomingMessage_Test
extends TestCase {
    public void testIncomingMessageIsNull_ThrowsIllegalArgumentException() throws Exception {
        new TestPlan(){

            @Override
            protected IncomingMessage createMessage() throws Exception {
                this.theCreateMessage = null;
                return this.theCreateMessage;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertNull((Object)this.theCreateMessage);
                Assert.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testMessageDoesNotHaveSignatures_ThrowsAgentException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasSignatures_Internal() {
                this.theHasSignatures = false;
                return this.theHasSignatures;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertEquals((int)1, (int)this.hasSignaturesCalls);
                Assert.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agenException = (AgentException)((Object)exception);
                Assert.assertEquals((Object)AgentError.UntrustedMessage, (Object)agenException.getError());
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToFindSenderSignatures() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasSignatures_Internal() {
                this.theHasSignatures = true;
                return this.theHasSignatures;
            }

            @Override
            protected boolean hasSenderSignatures_Internal() {
                this.theHasSenderSignatures = true;
                return this.theHasSenderSignatures;
            }

            @Override
            protected void findSenderSignatures_Internal(IncomingMessage message) {
                Assert.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)1, (int)this.findSenderSignaturesCalls);
            }
        }.perform();
    }

    public void testMessageDoesNotHaveSenderSignatures_ThrowsAgentException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasSignatures_Internal() {
                this.theHasSignatures = true;
                return this.theHasSignatures;
            }

            @Override
            protected boolean hasSenderSignatures_Internal() {
                this.theHasSenderSignatures = false;
                return this.theHasSenderSignatures;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                Assert.assertEquals((int)1, (int)this.hasSignaturesCalls);
                Assert.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agenException = (AgentException)((Object)exception);
                Assert.assertEquals((Object)AgentError.MissingSenderSignature, (Object)agenException.getError());
            }
        }.perform();
    }

    public void testRecipientsTrustedSignatureIsNull_SetsTrustEnforcementStatusAsFailed() throws Exception {
        new MessageHasSenderSignatures(){

            @Override
            protected DefaultMessageSignatureImpl findTrustedSignature_Internal(IncomingMessage message, Collection<X509Certificate> anchors) {
                this.theFindTrustedSignature = null;
                return this.theFindTrustedSignature;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)0, (int)this.findTrustedSignatureCalls);
                Assert.assertEquals((Object)TrustEnforcementStatus.Failed, (Object)this.recip.getStatus());
            }
        }.perform();
    }

    public void testThumbprintIsNotVerified_SetsTrustEnforcementStatusAsSuccess_ThumbprintMismatch() throws Exception {
        new MessageHasSenderSignatures(){

            @Override
            protected boolean isThumbprintVerified_Internal() {
                this.theIsThumbprintVerified = false;
                return this.theIsThumbprintVerified;
            }

            @Override
            protected void doAssertions() throws Exception {
                Assert.assertEquals((int)0, (int)this.findTrustedSignatureCalls);
                Assert.assertEquals((Object)TrustEnforcementStatus.Failed, (Object)this.recip.getStatus());
            }
        }.perform();
    }

    class MessageHasSenderSignatures
    extends TestPlan {
        protected NHINDAddress recip;
        protected Collection<X509Certificate> theGetTrustAnchors;
        protected int getTrustAnchorsCalls;
        protected X509CertificateEx internalCert;
        protected boolean theIsThumbprintVerified;
        protected int isThumbprintVerifiedCalls;

        MessageHasSenderSignatures() {
            this.getTrustAnchorsCalls = 0;
            this.isThumbprintVerifiedCalls = 0;
        }

        @Override
        protected boolean hasSignatures_Internal() {
            this.theHasSignatures = true;
            return this.theHasSignatures;
        }

        @Override
        protected boolean hasSenderSignatures_Internal() {
            this.theHasSenderSignatures = true;
            return this.theHasSenderSignatures;
        }

        @Override
        protected NHINDAddressCollection getDomainRecipients_Internal() {
            this.theGetDomainRecipients = new NHINDAddressCollection();
            this.recip = new NHINDAddress(""){

                public Collection<X509Certificate> getTrustAnchors() {
                    ++MessageHasSenderSignatures.this.getTrustAnchorsCalls;
                    return MessageHasSenderSignatures.this.getTrustAnchors_Internal();
                }
            };
            this.theGetDomainRecipients.add((Object)this.recip);
            return this.theGetDomainRecipients;
        }

        protected Collection<X509Certificate> getTrustAnchors_Internal() {
            this.theGetTrustAnchors = new ArrayList<X509Certificate>();
            return this.theGetTrustAnchors;
        }

        protected SignerInformation createSignerInformation() throws Exception {
            this.internalCert = TestUtils.getInternalCert("user1");
            String testMessage = TestUtils.readResource("MultipartMimeMessage.txt");
            MimeMessage entity = EntitySerializer.Default.deserialize(testMessage);
            Message message = new Message(entity);
            MimeEntity entityToSig = message.extractEntityForSignature(true);
            byte[] messageBytes = EntitySerializer.Default.serializeToBytes((MimePart)entityToSig);
            MimeBodyPart partToSign = null;
            try {
                partToSign = new MimeBodyPart((InputStream)new ByteArrayInputStream(messageBytes));
            }
            catch (Exception e) {
                // empty catch block
            }
            SMIMESignedGenerator gen = new SMIMESignedGenerator();
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.dES_EDE3_CBC);
            caps.addCapability(SMIMECapability.rC2_CBC, 128);
            caps.addCapability(SMIMECapability.dES_CBC);
            caps.addCapability(new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            caps.addCapability(PKCSObjectIdentifiers.x509Certificate);
            signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
            ArrayList<X509CertificateEx> certList = new ArrayList<X509CertificateEx>();
            gen.addSigner(this.internalCert.getPrivateKey(), (X509Certificate)this.internalCert, SMIMESignedGenerator.DIGEST_SHA1, new AttributeTable((DEREncodableVector)signedAttrs), null);
            certList.add(this.internalCert);
            MimeMultipart retVal = null;
            CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), CryptoExtensions.getJCEProviderName());
            gen.addCertificatesAndCRLs(certsAndcrls);
            retVal = gen.generate(partToSign, CryptoExtensions.getJCEProviderName());
            ByteArrayOutputStream oStream = new ByteArrayOutputStream();
            retVal.writeTo((OutputStream)oStream);
            oStream.flush();
            byte[] serialzedBytes = oStream.toByteArray();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(serialzedBytes, retVal.getContentType());
            MimeMultipart verifyMM = new MimeMultipart((DataSource)dataSource);
            CMSSignedData signeddata = new CMSSignedData((CMSProcessable)new CMSProcessableBodyPartInbound((BodyPart)partToSign), verifyMM.getBodyPart(1).getInputStream());
            SignerInformationStore signers = signeddata.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            if (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                return signer;
            }
            return null;
        }

        @Override
        protected DefaultMessageSignatureImpl findTrustedSignature_Internal(IncomingMessage message, Collection<X509Certificate> anchors) {
            try {
                this.theFindTrustedSignature = new DefaultMessageSignatureImpl(this.createSignerInformation(), false, (X509Certificate)this.internalCert){

                    public boolean isThumbprintVerified() {
                        ++MessageHasSenderSignatures.this.isThumbprintVerifiedCalls;
                        return MessageHasSenderSignatures.this.isThumbprintVerified_Internal();
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail();
            }
            return this.theFindTrustedSignature;
        }

        protected boolean isThumbprintVerified_Internal() {
            this.theIsThumbprintVerified = false;
            return this.theIsThumbprintVerified;
        }
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int findSenderSignaturesCalls = 0;
        protected DefaultMessageSignatureImpl theFindTrustedSignature;
        protected int findTrustedSignatureCalls = 0;
        protected IncomingMessage theCreateMessage;
        protected boolean theHasSignatures;
        protected int hasSignaturesCalls = 0;
        protected boolean theHasSenderSignatures;
        protected int hasSenderSignaturesCalls = 0;
        protected NHINDAddressCollection theGetDomainRecipients;
        protected int getDomainRecipientsCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            TrustModel impl = this.createTrustModel();
            impl.enforce(this.createMessage());
            this.doAssertions();
        }

        protected TrustModel createTrustModel() throws Exception {
            return new TrustModel(){

                protected void findSenderSignatures(IncomingMessage message) {
                    ++TestPlan.this.findSenderSignaturesCalls;
                    TestPlan.this.findSenderSignatures_Internal(message);
                }

                protected DefaultMessageSignatureImpl findTrustedSignature(IncomingMessage message, Collection<X509Certificate> anchors) {
                    ++TestPlan.this.findTrustedSignatureCalls;
                    return TestPlan.this.findTrustedSignature_Internal(message, anchors);
                }
            };
        }

        protected void findSenderSignatures_Internal(IncomingMessage message) {
        }

        protected DefaultMessageSignatureImpl findTrustedSignature_Internal(IncomingMessage message, Collection<X509Certificate> anchors) {
            this.theFindTrustedSignature = null;
            return this.theFindTrustedSignature;
        }

        protected IncomingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new IncomingMessage(msg, recipients, sender){

                public boolean hasSignatures() {
                    ++TestPlan.this.hasSignaturesCalls;
                    return TestPlan.this.hasSignatures_Internal();
                }

                public boolean hasSenderSignatures() {
                    ++TestPlan.this.hasSenderSignaturesCalls;
                    return TestPlan.this.hasSenderSignatures_Internal();
                }

                public NHINDAddressCollection getDomainRecipients() {
                    ++TestPlan.this.getDomainRecipientsCalls;
                    return TestPlan.this.getDomainRecipients_Internal();
                }
            };
            return this.theCreateMessage;
        }

        protected boolean hasSignatures_Internal() {
            this.theHasSignatures = false;
            return this.theHasSignatures;
        }

        protected boolean hasSenderSignatures_Internal() {
            this.theHasSenderSignatures = false;
            return this.theHasSenderSignatures;
        }

        protected NHINDAddressCollection getDomainRecipients_Internal() {
            this.theGetDomainRecipients = new NHINDAddressCollection();
            return this.theGetDomainRecipients;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

