/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.trust;

import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collection;
import junit.framework.TestCase;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.trust.TrustChainValidator;
import org.nhindirect.stagent.utils.TestUtils;

public class TrustChainValidator_downloadCertsFromAIATest
extends TestCase {
    protected String filePrefix;

    public void setUp() {
        File file = new File("./src/test/resources/certs/bob.der");
        this.filePrefix = file.getAbsolutePath().contains(":/") ? "file:///" : "file:///";
    }

    public void testDownloadCertsFromAIA_validURL_singleCert_assertDownloaded() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.der");
        X509Certificate downloadedCert = (X509Certificate)validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath()).iterator().next();
        TrustChainValidator_downloadCertsFromAIATest.assertNotNull((Object)downloadedCert);
        TrustChainValidator_downloadCertsFromAIATest.assertEquals((Object)TestUtils.loadCertificate("bob.der"), (Object)downloadedCert);
    }

    public void testDownloadCertsFromAIA_validURL_collectionCert_assertDownloaded() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/cmsRandomizer.p7b");
        Collection downloadedCerts = validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath());
        TrustChainValidator_downloadCertsFromAIATest.assertNotNull((Object)downloadedCerts);
        TrustChainValidator_downloadCertsFromAIATest.assertEquals((int)6, (int)downloadedCerts.size());
    }

    public void testDownloadCertsFromAIA_certNotAtURL_assertException() throws Exception {
        TrustChainValidator validator = new TrustChainValidator();
        File fl = new File("src/test/resources/certs/bob.derdd");
        boolean exceptionOccurred = false;
        try {
            validator.downloadCertsFromAIA(this.filePrefix + fl.getAbsolutePath());
        }
        catch (NHINDException e) {
            exceptionOccurred = true;
        }
        TrustChainValidator_downloadCertsFromAIATest.assertTrue((boolean)exceptionOccurred);
    }
}

