/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import junit.framework.TestCase;
import org.nhindirect.stagent.AgentError;
import org.nhindirect.stagent.AgentException;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.NHINDAddress;
import org.nhindirect.stagent.NHINDAddressCollection;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.cryptography.Cryptographer;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.mail.Message;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustEnforcementStatus;
import org.nhindirect.stagent.trust.TrustError;
import org.nhindirect.stagent.trust.TrustException;
import org.nhindirect.stagent.trust.TrustModel;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessIncomingMessage_Test
extends TestCase {
    public void testMessageDoesNotHaveDomainRecips_ThrowsAgentException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasDomainRecipients_Internal() {
                this.theHasDomainRecipients = false;
                return this.theHasDomainRecipients;
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                TestCase.assertTrue((boolean)(exception instanceof AgentException));
                AgentException agentException = (AgentException)((Object)exception);
                TestCase.assertTrue((boolean)agentException.getError().equals(AgentError.NoTrustedRecipients));
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToBindAddressMethod() throws Exception {
        new TestPlan(){

            @Override
            protected void bindAddresses_Internal(IncomingMessage message) {
                TestCase.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertEquals((int)1, (int)this.bindAddressesCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToDecryptSignedContentMethod() throws Exception {
        new TestPlan(){

            @Override
            protected void decryptSignedContent_Internal(IncomingMessage message) {
                TestCase.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertEquals((int)1, (int)this.decryptSignedContentCalls);
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToUnwrapMessageMethod() throws Exception {
        new TestPlan(){

            @Override
            protected Message unwrapMessage_Internal(Message message) {
                TestCase.assertEquals((Object)this.theCreateMessage.getMessage(), (Object)message);
                return super.unwrapMessage_Internal(message);
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertEquals((int)1, (int)this.unwrapMessageCalls);
            }
        }.perform();
    }

    public void testMessageReturnedFromUnwrapMessageMethodIsSetInIncomingMessage() throws Exception {
        new TestPlan(){

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertEquals((int)1, (int)this.unwrapMessageCalls);
                TestCase.assertEquals((Object)this.theUnwrapMessage, (Object)this.theCreateMessage.getMessage());
            }
        }.perform();
    }

    public void testCorrectMessageParamIsPassedToEnforce() throws Exception {
        new TestPlan(){

            @Override
            protected void enforce_Internal(IncomingMessage message) {
                TestCase.assertEquals((Object)this.theCreateMessage, (Object)message);
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertEquals((int)1, (int)this.enforceCalls);
            }
        }.perform();
    }

    public void testMessageHasDomainRecipients_CategorizeRecipientsIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasDomainRecipients_Internal() {
                this.theHasDomainRecipients = true;
                return this.theHasDomainRecipients;
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.assertTrue((this.hasDomainRecipientsCalls > 0 ? 1 : 0) != 0);
                TestCase.assertEquals((int)1, (int)this.categorizeRecipientsCalls);
            }
        }.perform();
    }

    public void testMessageDoesNotHaveDomainRecipientsAfterCategorizeRecipientsIsCalled_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasDomainRecipients_Internal() {
                this.theHasDomainRecipients = this.hasDomainRecipientsCalls != 3;
                return this.theHasDomainRecipients;
            }

            @Override
            protected void doAssertions() throws Exception {
                TestCase.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                TestCase.assertEquals((int)3, (int)this.hasDomainRecipientsCalls);
                TestCase.assertTrue((boolean)(exception instanceof TrustException));
                TrustException trustException = (TrustException)exception;
                TestCase.assertTrue((boolean)trustException.getError().equals(TrustError.NoTrustedRecipients));
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected int bindAddressesCalls = 0;
        protected int decryptSignedContentCalls = 0;
        protected Message theUnwrapMessage;
        protected int unwrapMessageCalls = 0;
        protected IncomingMessage theCreateMessage;
        protected int categorizeRecipientsCalls = 0;
        protected boolean theHasDomainRecipients;
        protected int hasDomainRecipientsCalls = 0;
        protected TrustModel theCreateTrustModel;
        protected int enforceCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createNHINDAgent();
            impl.processMessage(this.createMessage());
            this.doAssertions();
        }

        protected DefaultNHINDAgent createNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver(), this.createTrustModel(), (Cryptographer)new SMIMECryptographerImpl()){

                protected void bindAddresses(IncomingMessage message) {
                    ++TestPlan.this.bindAddressesCalls;
                    TestPlan.this.bindAddresses_Internal(message);
                }

                protected void decryptSignedContent(IncomingMessage message) {
                    ++TestPlan.this.decryptSignedContentCalls;
                    TestPlan.this.decryptSignedContent_Internal(message);
                }

                protected Message unwrapMessage(Message message) {
                    ++TestPlan.this.unwrapMessageCalls;
                    return TestPlan.this.unwrapMessage_Internal(message);
                }
            };
        }

        protected void bindAddresses_Internal(IncomingMessage message) {
        }

        protected void decryptSignedContent_Internal(IncomingMessage message) {
        }

        protected Message unwrapMessage_Internal(Message message) {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            try {
                mimeMsg.setText("");
                this.theUnwrapMessage = new Message((MimeMessage)mimeMsg);
            }
            catch (MessagingException e) {
                e.printStackTrace();
                TestCase.fail();
            }
            return this.theUnwrapMessage;
        }

        protected IncomingMessage createMessage() throws Exception {
            SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
            mimeMsg.setText("");
            Message msg = new Message((MimeMessage)mimeMsg);
            NHINDAddressCollection recipients = new NHINDAddressCollection();
            recipients.add((Object)new NHINDAddress(""));
            NHINDAddress sender = new NHINDAddress("");
            this.theCreateMessage = new IncomingMessage(msg, recipients, sender){

                public boolean hasDomainRecipients() {
                    ++TestPlan.this.hasDomainRecipientsCalls;
                    return TestPlan.this.hasDomainRecipients_Internal();
                }

                protected void categorizeRecipients(TrustEnforcementStatus minTrustStatus) {
                    ++TestPlan.this.categorizeRecipientsCalls;
                    TestPlan.this.categorizeRecipients_Internal(minTrustStatus);
                }
            };
            return this.theCreateMessage;
        }

        protected void categorizeRecipients_Internal(TrustEnforcementStatus minTrustStatus) {
        }

        protected boolean hasDomainRecipients_Internal() {
            this.theHasDomainRecipients = true;
            return this.theHasDomainRecipients;
        }

        protected void enforce_Internal(IncomingMessage message) {
        }

        protected TrustModel createTrustModel() {
            this.theCreateTrustModel = new TrustModel(){

                public void enforce(IncomingMessage message) {
                    ++TestPlan.this.enforceCalls;
                    TestPlan.this.enforce_Internal(message);
                }
            };
            return this.theCreateTrustModel;
        }

        protected void doAssertions() throws Exception {
        }
    }
}

