/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent;

import java.io.ByteArrayOutputStream;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import junit.framework.TestCase;
import org.nhindirect.stagent.DefaultNHINDAgent;
import org.nhindirect.stagent.IncomingMessage;
import org.nhindirect.stagent.cert.CertificateResolver;
import org.nhindirect.stagent.cert.impl.KeyStoreCertificateStore;
import org.nhindirect.stagent.trust.DefaultTrustAnchorResolver;
import org.nhindirect.stagent.trust.TrustAnchorResolver;
import org.nhindirect.stagent.utils.BaseTestPlan;
import org.nhindirect.stagent.utils.SecondaryMimeMessage;

public class DefaultNHINDAgent_ProcessIncoming_AsRawString_Test
extends TestCase {
    public void testMessageTxtIsNull_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected String createMessageText() throws Exception {
                this.theCreateMessageText = null;
                return this.theCreateMessageText;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                TestCase.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                TestCase.assertNull((Object)this.theCreateMessageText);
                TestCase.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testMessageTxtIsBlank_ThrowsException() throws Exception {
        new TestPlan(){

            @Override
            protected String createMessageText() throws Exception {
                this.theCreateMessageText = "";
                return this.theCreateMessageText;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                TestCase.fail();
            }

            @Override
            protected void assertException(Exception exception) throws Exception {
                TestCase.assertEquals((int)0, (int)this.theCreateMessageText.length());
                TestCase.assertTrue((boolean)(exception instanceof IllegalArgumentException));
            }
        }.perform();
    }

    public void testMessageTxtIsValid_ProcessIncomingMethodIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected String createMessageText() throws Exception {
                SecondaryMimeMessage mimeMsg = new SecondaryMimeMessage();
                mimeMsg.setText("");
                mimeMsg.setRecipients(Message.RecipientType.TO, "some");
                mimeMsg.setSender((Address)new InternetAddress());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                mimeMsg.writeTo(bos);
                this.theCreateMessageText = new String(bos.toByteArray());
                return this.theCreateMessageText;
            }

            @Override
            protected void doAssertions(IncomingMessage processIncoming) throws Exception {
                TestCase.assertEquals((int)1, (int)this.processIncomingCalls);
                TestCase.assertNotNull((Object)this.theProcessIncoming);
                TestCase.assertEquals((Object)this.theProcessIncoming, (Object)processIncoming);
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected IncomingMessage theProcessIncoming;
        protected int processIncomingCalls = 0;
        protected String theCreateMessageText;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            DefaultNHINDAgent impl = this.createDefaultNHINDAgent();
            IncomingMessage processIncoming = impl.processIncoming(this.createMessageText());
            this.doAssertions(processIncoming);
        }

        protected DefaultNHINDAgent createDefaultNHINDAgent() throws Exception {
            return new DefaultNHINDAgent("", (CertificateResolver)new KeyStoreCertificateStore(), (CertificateResolver)new KeyStoreCertificateStore(), (TrustAnchorResolver)new DefaultTrustAnchorResolver()){

                public IncomingMessage processIncoming(IncomingMessage message) {
                    ++TestPlan.this.processIncomingCalls;
                    return TestPlan.this.processIncoming_Internal(message);
                }
            };
        }

        protected IncomingMessage processIncoming_Internal(IncomingMessage message) {
            this.theProcessIncoming = message;
            return this.theProcessIncoming;
        }

        protected String createMessageText() throws Exception {
            this.theCreateMessageText = "createMessageText";
            return this.theCreateMessageText;
        }

        protected void doAssertions(IncomingMessage processIncoming) throws Exception {
        }
    }
}

