/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.lang.ref.SoftReference;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509CRL;
import java.util.Calendar;
import java.util.UUID;
import javax.security.auth.x500.X500Principal;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.x509.X509V2CRLGenerator;
import org.mockito.Mockito;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;
import org.nhindirect.stagent.utils.TestUtils;

public class CRLRevocationManager_getCrlFromUriTest
extends TestCase {
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    public void testGetCrlFromUri_emptyURI_assertNull() {
        X509CRL crl = CRLRevocationManager.getInstance().getCrlFromUri("");
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)crl);
    }

    public void testGetCrlFromUri_nullURI_assertNull() {
        X509CRL crl = CRLRevocationManager.getInstance().getCrlFromUri(null);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)crl);
    }

    public void testGetCrlFromUri_existsInCache_assertCRLFound() {
        String uri = "http://localhost:8080/master.crl";
        Calendar nextUpdateDate = Calendar.getInstance();
        nextUpdateDate.set(1, nextUpdateDate.get(1) + 10);
        X509CRL crl = (X509CRL)Mockito.mock(X509CRL.class);
        Mockito.when((Object)crl.getNextUpdate()).thenReturn((Object)nextUpdateDate.getTime());
        CRLRevocationManager.cache.put(uri, new SoftReference<X509CRL>(crl));
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNotNull((Object)retCrl);
        CRLRevocationManager_getCrlFromUriTest.assertEquals((Object)crl, (Object)retCrl);
    }

    public void testGetCrlFromUri_existsInCache_crlExpire_assertCRLNotFound() {
        String uri = "http://localhost:8080/master.crl";
        Calendar nextUpdateDate = Calendar.getInstance();
        nextUpdateDate.set(1, nextUpdateDate.get(1) - 10);
        X509CRL crl = (X509CRL)Mockito.mock(X509CRL.class);
        Mockito.when((Object)crl.getNextUpdate()).thenReturn((Object)nextUpdateDate.getTime());
        CRLRevocationManager.cache.put(uri, new SoftReference<X509CRL>(crl));
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
        CRLRevocationManager_getCrlFromUriTest.assertEquals((int)0, (int)CRLRevocationManager.cache.size());
    }

    public void testGetCrlFromUri_existsInCache_softRefRemoved_assertCRLNotFound() {
        String uri = "http://localhost:8080/master.crl";
        SoftReference softRef = (SoftReference)Mockito.mock(SoftReference.class);
        Mockito.when(softRef.get()).thenReturn(null);
        CRLRevocationManager.cache.put(uri, softRef);
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
        CRLRevocationManager_getCrlFromUriTest.assertEquals((int)0, (int)CRLRevocationManager.cache.size());
    }

    public void testGetCrlFromUri_notInCache_assertCRLNotFound() {
        String uri = "http://localhost:8080/master.crl";
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
    }

    public void testGetCrlFromUri_notInCache_noCacheFile_assertCRLNotFound() {
        CRLRevocationManager.initCRLCacheLocation();
        String uri = "http://localhost:8080/master.crl";
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
    }

    public void testGetCrlFromUri_notInCache_loadFromCacheFile_assertCRLFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uri = "http://localhost:8080/certs.crl";
        X509CRL crl = (X509CRL)TestUtils.loadCRL("certs.crl");
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPair pair = kpGen.generateKeyPair();
        Calendar cal = Calendar.getInstance();
        cal.set(1, cal.get(1) + 10);
        X509V2CRLGenerator crlGen = new X509V2CRLGenerator();
        crlGen.setIssuerDN(new X500Principal("CN=Test CRL"));
        crlGen.setNextUpdate(cal.getTime());
        crlGen.setSignatureAlgorithm("SHA256withRSAEncryption");
        crlGen.setThisUpdate(Calendar.getInstance().getTime());
        crlGen.addCRL(crl);
        crl = crlGen.generate(pair.getPrivate(), "BC");
        CRLRevocationManager.INSTANCE.writeCRLCacheFile(uri, crl);
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNotNull((Object)retCrl);
        CRLRevocationManager_getCrlFromUriTest.assertEquals((Object)crl, (Object)retCrl);
    }

    public void testGetCrlFromUri_notInCache_loadFromCacheFile_expiredCRL_assertCRLFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uri = "http://localhost:8080/certs.crl";
        X509CRL crl = (X509CRL)TestUtils.loadCRL("certs.crl");
        CRLRevocationManager.INSTANCE.writeCRLCacheFile(uri, crl);
        String fileName = CRLRevocationManager.getCacheFileName((String)uri);
        File writeFile = new File(fileName);
        CRLRevocationManager_getCrlFromUriTest.assertTrue((boolean)writeFile.exists());
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
        writeFile = new File(fileName);
        CRLRevocationManager_getCrlFromUriTest.assertFalse((boolean)writeFile.exists());
    }

    public void testGetCrlFromUri_notInCache_loadFromCacheFile_corruptFile_assertCRLNotFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String uri = "http://localhost:8080/certs.crl";
        String fileName = CRLRevocationManager.getCacheFileName((String)uri);
        File writeFile = new File(fileName);
        FileUtils.writeByteArrayToFile((File)writeFile, (byte[])new byte[]{9, 6, 4});
        X509CRL retCrl = CRLRevocationManager.getInstance().getCrlFromUri(uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCrl);
        writeFile = new File(fileName);
        CRLRevocationManager_getCrlFromUriTest.assertFalse((boolean)writeFile.exists());
    }

    public void testGetCrlFromUri_fromURL_assertCRLFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        X509CRL crl = (X509CRL)TestUtils.loadCRL("certs.crl");
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        KeyPair pair = kpGen.generateKeyPair();
        Calendar cal = Calendar.getInstance();
        cal.set(1, cal.get(1) + 10);
        X509V2CRLGenerator crlGen = new X509V2CRLGenerator();
        crlGen.setIssuerDN(new X500Principal("CN=Test CRL"));
        crlGen.setNextUpdate(cal.getTime());
        crlGen.setSignatureAlgorithm("SHA256withRSAEncryption");
        crlGen.setThisUpdate(Calendar.getInstance().getTime());
        crlGen.addCRL(crl);
        crl = crlGen.generate(pair.getPrivate(), "BC");
        String fileName = UUID.randomUUID().toString();
        final File crlFile = new File("target/" + fileName + ".crl");
        FileUtils.writeByteArrayToFile((File)crlFile, (byte[])crl.getEncoded());
        CRLRevocationManager mgr = new CRLRevocationManager(){

            protected String getNameString(String generalNameString) {
                return "file:///" + crlFile.getAbsolutePath();
            }
        };
        String uri = crlFile.getAbsolutePath();
        X509CRL retCRL = mgr.getCrlFromUri("file:///" + uri);
        CRLRevocationManager_getCrlFromUriTest.assertEquals((Object)crl, (Object)retCRL);
        String cacheFileName = CRLRevocationManager.getCacheFileName((String)("file:///" + uri));
        File cacheFile = new File(cacheFileName);
        CRLRevocationManager_getCrlFromUriTest.assertTrue((boolean)cacheFile.exists());
    }

    public void testGetCrlFromUri_fromURL_corruptEncoding_assertCRLNotFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String fileName = UUID.randomUUID().toString();
        final File crlFile = new File("target/" + fileName + ".crl");
        FileUtils.writeByteArrayToFile((File)crlFile, (byte[])new byte[]{93, 39, 0, 1});
        CRLRevocationManager mgr = new CRLRevocationManager(){

            protected String getNameString(String generalNameString) {
                return "file:///" + crlFile.getAbsolutePath();
            }
        };
        String uri = crlFile.getAbsolutePath();
        X509CRL retCRL = mgr.getCrlFromUri("file:///" + uri);
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCRL);
        String cacheFileName = CRLRevocationManager.getCacheFileName((String)("file:///" + uri));
        File cacheFile = new File(cacheFileName);
        CRLRevocationManager_getCrlFromUriTest.assertFalse((boolean)cacheFile.exists());
    }

    public void testGetCrlFromUri_fromURL_uriNotAvailable_assertCRLNotFound() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        X509CRL retCRL = CRLRevocationManager.getInstance().getCrlFromUri("file://target/bogusURI");
        CRLRevocationManager_getCrlFromUriTest.assertNull((Object)retCRL);
    }
}

