/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.mail.internet.InternetAddress;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_getCertificatesTest
extends BaseKeyStoreManagerCertStoreTest {
    public void testGetCertificate_noCertsInStore_assertNoFound() throws Exception {
        if (this.store != null) {
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertTrue((boolean)this.store.getCertificates("user1").isEmpty());
        }
    }

    public void testGetCertificate_existingCertsInStore_assertFound() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getCertificates("user1@cerner.com");
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }

    public void testGetCertificate_existingCertsInStore_findByEmailAddress_assertFound() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getCertificates(new InternetAddress("user1@cerner.com"));
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertEquals((int)1, (int)retrievedCerts.size());
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertTrue((boolean)(retrievedCert instanceof X509CertificateEx));
            CacheableKeyStoreManagerCertificateStore_getCertificatesTest.assertEquals((Object)user1, (Object)retrievedCert);
        }
    }
}

