/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.impl.BootstrappedKeyStoreProtectionManager;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.BaseKeyStoreManagerCertStoreTest;
import org.nhindirect.stagent.utils.TestUtils;

public class CacheableKeyStoreManagerCertificateStore_removeTest
extends BaseKeyStoreManagerCertStoreTest {
    public void testRemove_removingExistingCert_assertRemoved() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getAllCertificates();
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            CacheableKeyStoreManagerCertificateStore_removeTest.assertEquals((Object)user1, (Object)retrievedCert);
            this.store.remove((X509Certificate)user1);
            CacheableKeyStoreManagerCertificateStore_removeTest.assertTrue((boolean)this.store.getAllCertificates().isEmpty());
        }
    }

    public void testRemove_removingNonExistantCert_assertNotRemoved() throws Exception {
        if (this.store != null) {
            X509CertificateEx user1 = TestUtils.getInternalCert("user1");
            this.store.add((X509Certificate)user1);
            Collection retrievedCerts = this.store.getAllCertificates();
            X509Certificate retrievedCert = (X509Certificate)retrievedCerts.iterator().next();
            CacheableKeyStoreManagerCertificateStore_removeTest.assertEquals((Object)user1, (Object)retrievedCert);
            X509Certificate cacert = TestUtils.getInternalCACert("cacert");
            this.store.remove(cacert);
            CacheableKeyStoreManagerCertificateStore_removeTest.assertFalse((boolean)this.store.getAllCertificates().isEmpty());
        }
    }

    public void testRemove_nonMutableStore_assertException() throws Exception {
        if (this.store != null) {
            BootstrappedKeyStoreProtectionManager mgr = new BootstrappedKeyStoreProtectionManager();
            this.store.setKeyStoreManager((KeyStoreProtectionManager)mgr);
            boolean exceptionOccured = false;
            try {
                X509Certificate cacert = TestUtils.getInternalCACert("cacert");
                this.store.remove(cacert);
            }
            catch (IllegalStateException ex) {
                exceptionOccured = true;
            }
            CacheableKeyStoreManagerCertificateStore_removeTest.assertTrue((boolean)exceptionOccured);
        }
    }
}

