/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.nhindirect.common.options.OptionsManagerUtils;
import org.nhindirect.stagent.cert.CertCacheFactory;
import org.nhindirect.stagent.cert.impl.LDAPCertificateStore;

public class LDAPCertificateStore_getDefaultCachePolicyTest
extends TestCase {
    public void setUp() {
        OptionsManagerUtils.clearOptionsManagerInstance();
        CertCacheFactory.getInstance().flushAll();
    }

    public void tearDown() {
        OptionsManagerUtils.clearOptionsManagerOptions();
        CertCacheFactory.getInstance().flushAll();
    }

    public void testGetDefaultCachePolicyTest_useDefaultSettings_assertSettings() throws Exception {
        LDAPCertificateStore store = new LDAPCertificateStore();
        LDAPCertificateStore_getDefaultCachePolicyTest.assertNotNull((Object)store.cachePolicy);
        LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)1000, (int)store.cachePolicy.getMaxItems());
        LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)3600, (int)store.cachePolicy.getSubjectTTL());
    }

    public void testGetDefaultCachePolicyTest_useSettingsFromJVMParams_assertSettings() throws Exception {
        System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", "500");
        System.setProperty("org.nhindirect.stagent.cert.ldapresolver.CacheTTL", "1800");
        try {
            LDAPCertificateStore store = new LDAPCertificateStore();
            LDAPCertificateStore_getDefaultCachePolicyTest.assertNotNull((Object)store.cachePolicy);
            LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)500, (int)store.cachePolicy.getMaxItems());
            LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)1800, (int)store.cachePolicy.getSubjectTTL());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", "");
            System.setProperty("org.nhindirect.stagent.cert.ldapresolver.CacheTTL", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetDefaultCachePolicyTest_useSettingsFromPropertiesFile_assertSettings() throws Exception {
        File propFile = new File("./target/props/agentSettings.properties");
        if (propFile.exists()) {
            propFile.delete();
        }
        System.setProperty("org.nhindirect.stagent.PropertiesFile", "./target/props/agentSettings.properties");
        FileOutputStream outStream = null;
        try {
            outStream = FileUtils.openOutputStream((File)propFile);
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize=1200\r\n".getBytes());
            ((OutputStream)outStream).write("org.nhindirect.stagent.cert.ldapresolver.CacheTTL=900".getBytes());
            outStream.flush();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
        try {
            LDAPCertificateStore store = new LDAPCertificateStore();
            LDAPCertificateStore_getDefaultCachePolicyTest.assertNotNull((Object)store.cachePolicy);
            LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)1200, (int)store.cachePolicy.getMaxItems());
            LDAPCertificateStore_getDefaultCachePolicyTest.assertEquals((int)900, (int)store.cachePolicy.getSubjectTTL());
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cert.ldapresolver.MaxCacheSize", "");
            System.setProperty("org.nhindirect.stagent.cert.ldapresolver.CacheTTL", "");
            System.setProperty("org.nhindirect.stagent.PropertiesFile", "");
            propFile.delete();
        }
    }
}

