/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.File;
import java.security.cert.CRL;
import java.security.cert.X509CRL;
import junit.framework.TestCase;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.stagent.cert.impl.CRLRevocationManager;
import org.nhindirect.stagent.utils.TestUtils;

public class CRLRevocationManager_removeCRLCacheFileTest
extends TestCase {
    public void setUp() {
        CryptoExtensions.registerJCEProviders();
        CRLRevocationManager.initCRLCacheLocation();
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.crlCacheLocation = null;
    }

    public void tearDown() {
        CRLRevocationManager.getInstance().flush();
        CRLRevocationManager.initCRLCacheLocation();
    }

    public void testRemoveCRLCacheFile_removeExistingFile() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        CRL crlToWrite = TestUtils.loadCRL("certs.crl");
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager.getInstance().writeCRLCacheFile(distURI, (X509CRL)crlToWrite);
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertTrue((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
    }

    public void testRemoveCRLCacheFile_removeNonExistingFile() throws Exception {
        CRLRevocationManager.initCRLCacheLocation();
        String distURI = "http://localhost:8080/config";
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
    }

    public void testRemoveCRLCacheFile_noCacheLoction() throws Exception {
        String distURI = "http://localhost:8080/config";
        CRLRevocationManager_removeCRLCacheFileTest.assertEquals((String)"", (String)CRLRevocationManager.getCacheFileName((String)distURI));
        File crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
        CRLRevocationManager.getInstance().removeCrlCacheFile(distURI);
        crlFile = new File(CRLRevocationManager.getCacheFileName((String)distURI));
        CRLRevocationManager_removeCRLCacheFileTest.assertFalse((boolean)crlFile.exists());
    }
}

