/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cert.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.nhindirect.stagent.cert.impl.AttributeAdapter;
import org.nhindirect.stagent.cert.impl.AttributesAdapter;
import org.nhindirect.stagent.cert.impl.LdapCertUtilImpl;
import org.nhindirect.stagent.cert.impl.LdapEnvironment;
import org.nhindirect.stagent.utils.BaseTestPlan;

public class LdapCertUtilImpl_LdapSearch_Test
extends TestCase {
    public void testNoValuesForCertAttribute_ReturnsEmptyListofCertificates() throws Exception {
        new TestPlan(){

            @Override
            protected boolean hasMoreElements_Internal() {
                this.theHasMoreElements = this.hasMoreElementsCalls == 1;
                return this.theHasMoreElements;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
                TestCase.assertTrue((boolean)ldapSearch.isEmpty());
                TestCase.assertTrue((this.hasMoreElementsCalls > 0 ? 1 : 0) != 0);
            }
        }.perform();
    }

    public void testSearchResultIsNull_ReturnsEmptyListofCertificates() throws Exception {
        new TestPlan(){

            @Override
            protected NamingEnumeration<SearchResult> search_Internal(String name, String filter, SearchControls cons) throws NamingException {
                this.theSearch = null;
                return this.theSearch;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
                TestCase.assertTrue((boolean)ldapSearch.isEmpty());
            }
        }.perform();
    }

    public void testCertificateFormatIsPKCS12_processPKCS12FileFormatAndAddToCertificatesIsCalled() throws Exception {
        new TestPlan(){

            @Override
            protected String createCertificateFormat() {
                this.theCreateCertificateFormat = "pkcs12";
                return this.theCreateCertificateFormat;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
                TestCase.assertEquals((int)1, (int)this.processPKCS12FileFormatAndAddToCertificatesCalls);
            }
        }.perform();
    }

    public void testValueRetrievedFromLDAPIsDecoded() throws Exception {
        new TestPlan(){
            protected String value = "encode this value";

            @Override
            protected String createCertificateFormat() {
                this.theCreateCertificateFormat = "pkcs12";
                return this.theCreateCertificateFormat;
            }

            @Override
            protected Object nextElement_Internal() {
                Base64 base64 = new Base64();
                this.theNextElement = new String(base64.encode(this.value.getBytes()));
                System.out.println("encoded val" + this.theNextElement);
                return this.theNextElement;
            }

            @Override
            protected void processPKCS12FileFormatAndAddToCertificates_Internal(ByteArrayInputStream inputStream, ArrayList<X509Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
                int size = inputStream.available();
                byte[] bytes = new byte[size];
                inputStream.read(bytes, 0, size);
                String input = new String(bytes);
                TestCase.assertEquals((String)this.value, (String)input);
                TestCase.assertNotSame((Object)this.theNextElement, (Object)input);
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
                TestCase.assertEquals((int)1, (int)this.processPKCS12FileFormatAndAddToCertificatesCalls);
            }
        }.perform();
    }

    public void testCertificateFormatIsX509_CertificateIsAddedCorrectly() throws Exception {
        new TestPlan(){

            @Override
            protected Object nextElement_Internal() {
                BufferedInputStream f = null;
                try {
                    File fl = new File("testfile");
                    int idx = fl.getAbsolutePath().lastIndexOf("testfile");
                    String path = fl.getAbsolutePath().substring(0, idx);
                    byte[] buffer = new byte[(int)new File(path + "src/test/resources/certs/bob.der").length() + 100];
                    f = new BufferedInputStream(new FileInputStream(path + "src/test/resources/certs/bob.der"));
                    f.read(buffer);
                    Base64 base64 = new Base64();
                    this.theNextElement = new String(base64.encode(buffer));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail();
                    IOUtils.closeQuietly(f);
                }
                return this.theNextElement;
            }

            @Override
            protected String createCertificateFormat() {
                this.theCreateCertificateFormat = "X509";
                return this.theCreateCertificateFormat;
            }

            @Override
            protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
                TestCase.assertEquals((int)1, (int)this.nextElementCalls);
                TestCase.assertNotNull(ldapSearch);
                TestCase.assertEquals((int)1, (int)ldapSearch.size());
                X509Certificate cert = ldapSearch.iterator().next();
                TestCase.assertTrue((boolean)(cert instanceof X509Certificate));
                TestCase.assertEquals((String)"EMAILADDRESS=bob@nhind.hsgincubator.com, CN=Bob Patel, OU=Incubator, O=HSG, L=Redmond, ST=WA, C=US", (String)cert.getSubjectX500Principal().toString());
            }
        }.perform();
    }

    abstract class TestPlan
    extends BaseTestPlan {
        protected InitialDirContext theGetInitialDirContext;
        protected int getInitialDirContextCalls = 0;
        protected NamingEnumeration<SearchResult> theSearch;
        protected int searchCalls = 0;
        protected boolean theHasMore;
        protected int hasMoreCalls = 0;
        protected SearchResult theNextElement_SearchResult;
        protected int nextElementCalls_SearchResult = 0;
        protected SearchResult theNext;
        protected int nextCalls = 0;
        protected Attributes theGetAttributes;
        protected int getAttributesCalls = 0;
        protected Attribute theGetByAttrId;
        protected int getCallsByAttrId = 0;
        protected NamingEnumeration<?> theGetAll;
        protected int getAllCalls = 0;
        protected boolean theHasMoreElements;
        protected int hasMoreElementsCalls = 0;
        protected String theNextElement;
        protected int nextElementCalls = 0;
        protected int closeDirContextCalls = 0;
        protected String theCreateSubjectName;
        protected LdapEnvironment theCreateLdapEnvironment;
        protected int getEnvCalls = 0;
        protected Hashtable<String, String> theGetEnv;
        protected int getLdapSearchBaseCalls = 0;
        protected String theGetLdapSearchBase;
        protected int getLdapSearchFilterCalls = 0;
        protected String theGetLdapSearchFilter;
        protected String theGetReturningCertAttribute;
        protected int getReturningCertAttributeCalls = 0;
        protected String theGetLdapSearchAttribute;
        protected int getLdapSearchAttributeCalls = 0;
        protected String theCreateLdapSearchTarget;
        protected String theCreateKeyStorePassword;
        protected int toCharArrayCalls = 0;
        protected char[] theToCharArray;
        protected String theCreateCertificateFormat;
        protected int equalsIgnoreCaseCalls = 0;
        protected boolean theEqualsIgnoreCase;
        protected int processPKCS12FileFormatAndAddToCertificatesCalls = 0;

        TestPlan() {
        }

        @Override
        protected void performInner() throws Exception {
            LdapCertUtilImpl impl = this.createLdapCertUtilImpl();
            Collection ldapSearch = impl.ldapSearch(this.createSubjectName());
            this.doAssertions(ldapSearch);
        }

        protected LdapCertUtilImpl createLdapCertUtilImpl() throws Exception {
            return new LdapCertUtilImpl(this.createLdapEnvironment(), this.createKeyStorePassword(), this.createCertificateFormat()){

                protected InitialDirContext getInitialDirContext(Hashtable<String, String> env) throws NamingException {
                    ++TestPlan.this.getInitialDirContextCalls;
                    return TestPlan.this.getInitialDirContext_Internal(env);
                }

                protected void closeDirContext(DirContext dirContext) {
                    ++TestPlan.this.closeDirContextCalls;
                    TestPlan.this.closeDirContext_Internal(dirContext);
                }

                protected void processPKCS12FileFormatAndAddToCertificates(ByteArrayInputStream inputStream, ArrayList<X509Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
                    ++TestPlan.this.processPKCS12FileFormatAndAddToCertificatesCalls;
                    TestPlan.this.processPKCS12FileFormatAndAddToCertificates_Internal(inputStream, certificates);
                }
            };
        }

        protected InitialDirContext getInitialDirContext_Internal(Hashtable<String, String> env) throws NamingException {
            this.theGetInitialDirContext = new InitialDirContext(){

                @Override
                public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
                    ++TestPlan.this.searchCalls;
                    return TestPlan.this.search_Internal(name, filter, cons);
                }
            };
            return this.theGetInitialDirContext;
        }

        protected NamingEnumeration<SearchResult> search_Internal(String name, String filter, SearchControls cons) throws NamingException {
            this.theSearch = new NamingEnumeration<SearchResult>(){

                @Override
                public void close() throws NamingException {
                }

                @Override
                public boolean hasMore() throws NamingException {
                    ++TestPlan.this.hasMoreCalls;
                    return TestPlan.this.hasMore_Internal();
                }

                @Override
                public SearchResult next() throws NamingException {
                    ++TestPlan.this.nextCalls;
                    return TestPlan.this.next_Internal();
                }

                @Override
                public boolean hasMoreElements() {
                    ++TestPlan.this.hasMoreElementsCalls;
                    return TestPlan.this.hasMoreElements_Internal();
                }

                @Override
                public SearchResult nextElement() {
                    ++TestPlan.this.nextElementCalls_SearchResult;
                    return TestPlan.this.nextElement_SearchResult_Internal();
                }
            };
            return this.theSearch;
        }

        protected boolean hasMore_Internal() throws NamingException {
            this.theHasMore = this.hasMoreCalls == 1;
            return this.theHasMore;
        }

        protected SearchResult nextElement_SearchResult_Internal() {
            this.theNextElement_SearchResult = new SearchResult("", null, (Attributes)new AttributesAdapter()){

                @Override
                public Attributes getAttributes() {
                    ++TestPlan.this.getAttributesCalls;
                    return TestPlan.this.getAttributes_Internal();
                }
            };
            return this.theNextElement_SearchResult;
        }

        protected SearchResult next_Internal() throws NamingException {
            this.theNext = new SearchResult("", null, (Attributes)new AttributesAdapter()){

                @Override
                public Attributes getAttributes() {
                    ++TestPlan.this.getAttributesCalls;
                    return TestPlan.this.getAttributes_Internal();
                }
            };
            return this.theNext;
        }

        protected Attributes getAttributes_Internal() {
            this.theGetAttributes = new AttributesAdapter(){

                @Override
                public Attribute get(String attrID) {
                    ++TestPlan.this.getCallsByAttrId;
                    return TestPlan.this.get_Internal(attrID);
                }
            };
            return this.theGetAttributes;
        }

        protected Attribute get_Internal(String attrID) {
            this.theGetByAttrId = new AttributeAdapter(){

                @Override
                public NamingEnumeration<?> getAll() throws NamingException {
                    ++TestPlan.this.getAllCalls;
                    return TestPlan.this.getAll_Internal();
                }
            };
            return this.theGetByAttrId;
        }

        protected NamingEnumeration<?> getAll_Internal() throws NamingException {
            this.theGetAll = new NamingEnumeration<Object>(){

                @Override
                public void close() throws NamingException {
                }

                @Override
                public boolean hasMore() throws NamingException {
                    ++TestPlan.this.hasMoreCalls;
                    return TestPlan.this.hasMore_Internal();
                }

                @Override
                public SearchResult next() throws NamingException {
                    ++TestPlan.this.nextCalls;
                    return TestPlan.this.next_Internal();
                }

                @Override
                public boolean hasMoreElements() {
                    ++TestPlan.this.hasMoreElementsCalls;
                    return TestPlan.this.hasMoreElements_Internal();
                }

                @Override
                public Object nextElement() {
                    ++TestPlan.this.nextElementCalls;
                    return TestPlan.this.nextElement_Internal();
                }
            };
            return this.theGetAll;
        }

        protected boolean hasMoreElements_Internal() {
            this.theHasMoreElements = this.hasMoreElementsCalls == 1 || this.hasMoreElementsCalls == 2;
            return this.theHasMoreElements;
        }

        protected Object nextElement_Internal() {
            this.theNextElement = "";
            return this.theNextElement;
        }

        protected void closeDirContext_Internal(DirContext dirContext) {
        }

        protected String createSubjectName() throws Exception {
            this.theCreateSubjectName = "createSubjectName";
            return this.theCreateSubjectName;
        }

        protected Hashtable<String, String> getEnv_Internal() {
            this.theGetEnv = new Hashtable();
            return this.theGetEnv;
        }

        protected String getReturningCertAttribute_Internal() {
            this.theGetReturningCertAttribute = "getReturningCertAttribute";
            return this.theGetReturningCertAttribute;
        }

        protected String getLdapSearchBase_Internal() {
            this.theGetLdapSearchBase = "getLdapSearchBase";
            return this.theGetLdapSearchBase;
        }

        protected String getLdapSearchFilter_Internal() {
            this.theGetLdapSearchFilter = "getLdapSearchFilter";
            return this.theGetLdapSearchFilter;
        }

        protected LdapEnvironment createLdapEnvironment() {
            this.theCreateLdapEnvironment = new LdapEnvironment(null, null, null, null){

                public Hashtable<String, String> getEnv() {
                    ++TestPlan.this.getEnvCalls;
                    return TestPlan.this.getEnv_Internal();
                }

                public String getReturningCertAttribute() {
                    ++TestPlan.this.getReturningCertAttributeCalls;
                    return TestPlan.this.getReturningCertAttribute_Internal();
                }

                public String getLdapSearchBase() {
                    ++TestPlan.this.getLdapSearchBaseCalls;
                    return TestPlan.this.getLdapSearchBase_Internal();
                }

                public String getLdapSearchAttribute() {
                    ++TestPlan.this.getLdapSearchAttributeCalls;
                    return TestPlan.this.getLdapSearchAttribute_Internal();
                }
            };
            return this.theCreateLdapEnvironment;
        }

        protected String getLdapSearchAttribute_Internal() {
            this.theGetLdapSearchAttribute = "getLdapSearchAttribute";
            return this.theGetLdapSearchAttribute;
        }

        protected String createLdapSearchTarget() {
            this.theCreateLdapSearchTarget = "createLdapSearchTarget";
            return this.theCreateLdapSearchTarget;
        }

        protected char[] toCharArray_Internal() {
            this.theToCharArray = new char[0];
            return this.theToCharArray;
        }

        protected String createKeyStorePassword() {
            this.theCreateKeyStorePassword = "1kingpuff";
            return this.theCreateKeyStorePassword;
        }

        protected boolean equalsIgnoreCase_Internal(String anotherString) {
            this.theEqualsIgnoreCase = false;
            return this.theEqualsIgnoreCase;
        }

        protected String createCertificateFormat() {
            this.theCreateCertificateFormat = "pkcs12";
            return this.theCreateCertificateFormat;
        }

        protected void processPKCS12FileFormatAndAddToCertificates_Internal(ByteArrayInputStream inputStream, ArrayList<X509Certificate> certificates) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        }

        protected void doAssertions(Collection<X509Certificate> ldapSearch) throws Exception {
        }
    }
}

