/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.stagent.cryptography;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.common.crypto.PKCS11Credential;
import org.nhindirect.common.crypto.impl.BootstrappedPKCS11Credential;
import org.nhindirect.common.crypto.impl.StaticPKCS11TokenKeyStoreProtectionManager;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.stagent.NHINDException;
import org.nhindirect.stagent.SignatureValidationException;
import org.nhindirect.stagent.cert.X509CertificateEx;
import org.nhindirect.stagent.cert.impl.CacheableKeyStoreManagerCertificateStore;
import org.nhindirect.stagent.cryptography.DigestAlgorithm;
import org.nhindirect.stagent.cryptography.EncryptionAlgorithm;
import org.nhindirect.stagent.cryptography.SMIMECryptographerImpl;
import org.nhindirect.stagent.cryptography.SignedEntity;
import org.nhindirect.stagent.mail.MimeEntity;
import org.nhindirect.stagent.mail.MimeError;
import org.nhindirect.stagent.parser.EntitySerializer;
import org.nhindirect.stagent.utils.TestUtils;

public class CryptographerTest
extends TestCase {
    protected String pkcs11ProviderName;

    public void setUp() {
        CryptoExtensions.registerJCEProviders();
    }

    public void testEncryptAndDecryptMimeEntityAES128() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES128, true, false);
    }

    public void testEncryptAndDecryptMimeEntityAES256() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES256, true, false);
    }

    public void testEncryptAndDecryptMimeEntityRSA_3DES() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.RSA_3DES, false, false);
    }

    public void testEncryptAndDecryptMimeEntityAES192() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.AES192, true, false);
    }

    public void testEncryptAndDecryptMimeEntityRSA_3DES_enforceStrongEncr_assertException() throws Exception {
        this.testEncryptAndDecryptMimeEntity(EncryptionAlgorithm.RSA_3DES, true, true);
    }

    public void testEncryptAndDecryptMimeEntityDefaultAlg() throws Exception {
        this.testEncryptAndDecryptMimeEntity(null, true, false);
    }

    private void testEncryptAndDecryptMimeEntity(EncryptionAlgorithm encAlg, boolean enforceStrongEncryption, boolean expectDecException) throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        if (encAlg != null) {
            cryptographer.setEncryptionAlgorithm(encAlg);
        }
        cryptographer.setStrongEncryptionEnforced(Boolean.valueOf(enforceStrongEncryption));
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        ContentType type = new ContentType(encEntity.getContentType());
        CryptographerTest.assertTrue((boolean)type.match("application/pkcs7-mime"));
        CryptographerTest.assertFalse((boolean)type.match("application/x-pkcs7-mime"));
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        if (expectDecException) {
            boolean exceptionOccured = false;
            try {
                cryptographer.decrypt(encEntity, certex);
            }
            catch (Exception e) {
                exceptionOccured = true;
            }
            CryptographerTest.assertTrue((boolean)exceptionOccured);
        } else {
            MimeEntity decryEntity = cryptographer.decrypt(encEntity, certex);
            CryptographerTest.assertNotNull((Object)decryEntity);
            byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
            byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
            CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
        }
    }

    public void testEncryptAndDecryptMimeEntity_hsmDecryption() throws Exception {
        this.pkcs11ProviderName = TestUtils.setupSafeNetToken();
        if (!StringUtils.isEmpty((CharSequence)this.pkcs11ProviderName)) {
            this.testEncryptAndDecryptMimeEntity_hsmDecryption(EncryptionAlgorithm.AES128);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncryptAndDecryptMimeEntity_hsmDecryption(EncryptionAlgorithm encAlg) throws Exception {
        OptionsManager.destroyInstance();
        CryptoExtensions.registerJCEProviders();
        try {
            BootstrappedPKCS11Credential cred = new BootstrappedPKCS11Credential("1Kingpuff");
            StaticPKCS11TokenKeyStoreProtectionManager mgr = new StaticPKCS11TokenKeyStoreProtectionManager((PKCS11Credential)cred, "", "");
            CacheableKeyStoreManagerCertificateStore store = new CacheableKeyStoreManagerCertificateStore((KeyStoreProtectionManager)mgr);
            store.add((X509Certificate)TestUtils.getInternalCert("user1"));
            X509Certificate cert = TestUtils.getExternalCert("user1");
            SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
            cryptographer.setEncryptionAlgorithm(encAlg);
            MimeEntity entity = new MimeEntity();
            entity.setText("Hello world.");
            entity.setHeader("Content-Type", "text/plain");
            entity.setHeader("Content-Transfer-Encoding", "7bit");
            MimeEntity encEntity = cryptographer.encrypt(entity, cert);
            CryptographerTest.assertNotNull((Object)encEntity);
            KeyStore ks = KeyStore.getInstance("PKCS11");
            ks.load(null, "1Kingpuff".toCharArray());
            X509CertificateEx decryptCert = null;
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                Key key;
                String alias = aliases.nextElement();
                Certificate pkcs11Cert = ks.getCertificate(alias);
                if (pkcs11Cert == null || !(pkcs11Cert instanceof X509Certificate) || (key = ks.getKey(alias, null)) == null || !(key instanceof PrivateKey) || !CryptoExtensions.certSubjectContainsName((X509Certificate)((X509Certificate)pkcs11Cert), (String)"user1@cerner.com")) continue;
                decryptCert = X509CertificateEx.fromX509Certificate((X509Certificate)((X509Certificate)pkcs11Cert), (PrivateKey)((PrivateKey)key));
                break;
            }
            MimeEntity decryEntity = cryptographer.decrypt(encEntity, decryptCert);
            CryptographerTest.assertNotNull((Object)decryEntity);
            byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
            byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
            CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
        }
        finally {
            System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderName", "");
            System.setProperty("org.nhindirect.stagent.cryptography.JCESensitiveProviderClassNames", "");
            OptionsManager.destroyInstance();
        }
    }

    public void testEncryptAndDecryptMultipartEntityAES128() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES128, true);
    }

    public void testEncryptAndDecryptMultipartEntityAES192() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES192, true);
    }

    public void testEncryptAndDecryptMultipartEntityAES256() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.AES256, true);
    }

    public void testEncryptAndDecryptMultipartEntityRSA_3DES() throws Exception {
        this.testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm.RSA_3DES, false);
    }

    private void testEncryptAndDecryptMultipartEntity(EncryptionAlgorithm encAlgo, boolean enforceStrongEncryption) throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setEncryptionAlgorithm(encAlgo);
        cryptographer.setStrongEncryptionEnforced(Boolean.valueOf(enforceStrongEncryption));
        MimeEntity entityText = new MimeEntity();
        entityText.setText("Hello world.");
        entityText.setHeader("Content-Type", "text/plain");
        entityText.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity entityXML = new MimeEntity();
        entityXML.setText("<Test></Test>");
        entityXML.setHeader("Content-Type", "text/xml");
        MimeMultipart mpEntity = new MimeMultipart();
        mpEntity.addBodyPart((BodyPart)entityText);
        mpEntity.addBodyPart((BodyPart)entityXML);
        MimeEntity encEntity = cryptographer.encrypt(mpEntity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        MimeEntity decryEntity = cryptographer.decrypt(encEntity, certex);
        CryptographerTest.assertNotNull((Object)decryEntity);
        ByteArrayOutputStream oStream = new ByteArrayOutputStream();
        mpEntity.writeTo((OutputStream)oStream);
        InternetHeaders hdrs = new InternetHeaders();
        hdrs.addHeader("Content-Type", mpEntity.getContentType());
        MimeEntity orgEntity = new MimeEntity(hdrs, oStream.toByteArray());
        byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)orgEntity);
        System.out.println("Original:\r\n" + new String(entityBytes));
        System.out.println("\r\n\r\n\r\nNew:\r\n" + new String(decryEntityBytes));
        CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
    }

    public void testSignMimeEntitySHA256() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA256WITHRSA);
    }

    public void testSignMimeEntitySHA384() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA384WITHRSA);
    }

    public void testSignMimeEntitySHA512() throws Exception {
        this.testSignMimeEntity(DigestAlgorithm.SHA512WITHRSA);
    }

    private void testSignMimeEntity(DigestAlgorithm digAlg) throws Exception {
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setDigestAlgorithm(digAlg);
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        byte[] signedEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)signedEnt.getContent());
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(signedEntityBytes, entityBytes));
        CryptographerTest.assertNotNull((Object)signedEnt.getSignature());
        X509Certificate cert = TestUtils.getExternalCert("user1");
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testSignMimeEntity_SHA1Digest_forceStrongDigest_assertRejectValidation() throws Exception {
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setDigestAlgorithm(DigestAlgorithm.SHA1WITHRSA);
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        byte[] signedEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)signedEnt.getContent());
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(signedEntityBytes, entityBytes));
        CryptographerTest.assertNotNull((Object)signedEnt.getSignature());
        X509Certificate cert = TestUtils.getExternalCert("user1");
        boolean exceptionOccured = false;
        try {
            cryptographer.checkSignature(signedEnt, cert, new ArrayList());
        }
        catch (SignatureValidationException e) {
            exceptionOccured = true;
        }
        CryptographerTest.assertTrue((boolean)exceptionOccured);
    }

    public void testSignMimeEntity_SHA256Digest_forceStrongDigest_assertValidation() throws Exception {
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setDigestAlgorithm(DigestAlgorithm.SHA256WITHRSA);
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        byte[] signedEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)signedEnt.getContent());
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(signedEntityBytes, entityBytes));
        CryptographerTest.assertNotNull((Object)signedEnt.getSignature());
        X509Certificate cert = TestUtils.getExternalCert("user1");
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testSignMimeEntity_SHA1Digest_doNotforceStrongDigest_assertValidation() throws Exception {
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        cryptographer.setDigestAlgorithm(DigestAlgorithm.SHA1WITHRSA);
        cryptographer.setStrongDigestEnforced(Boolean.valueOf(false));
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        byte[] signedEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)signedEnt.getContent());
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(signedEntityBytes, entityBytes));
        CryptographerTest.assertNotNull((Object)signedEnt.getSignature());
        X509Certificate cert = TestUtils.getExternalCert("user1");
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testEncryptAndSignMimeEntity() throws Exception {
        X509Certificate cert = TestUtils.getInternalCACert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("user1");
        SignedEntity signedEnt = cryptographer.sign(entity, (X509Certificate)certex);
        CryptographerTest.assertNotNull((Object)signedEnt);
        cryptographer.checkSignature(signedEnt, cert, new ArrayList());
    }

    public void testEncryptWithSingleCert_wrongDecryptCert_assertFailDecrypt() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex = TestUtils.getInternalCert("altnameonly");
        boolean exceptionOccured = false;
        try {
            cryptographer.decrypt(encEntity, certex);
        }
        catch (NHINDException e) {
            if (e.getError().equals(MimeError.Unexpected)) {
                // empty if block
            }
            exceptionOccured = true;
        }
        CryptographerTest.assertTrue((boolean)exceptionOccured);
    }

    public void testEncryptWithSingleCert_decryptWithMutlipeCerts_onlyOneCertCorrect_assertDecrypted() throws Exception {
        X509Certificate cert = TestUtils.getExternalCert("user1");
        SMIMECryptographerImpl cryptographer = new SMIMECryptographerImpl();
        MimeEntity entity = new MimeEntity();
        entity.setText("Hello world.");
        entity.setHeader("Content-Type", "text/plain");
        entity.setHeader("Content-Transfer-Encoding", "7bit");
        MimeEntity encEntity = cryptographer.encrypt(entity, cert);
        CryptographerTest.assertNotNull((Object)encEntity);
        X509CertificateEx certex1 = TestUtils.getInternalCert("altnameonly");
        X509CertificateEx certex2 = TestUtils.getInternalCert("user1");
        MimeEntity decryEntity = cryptographer.decrypt(encEntity, Arrays.asList(certex1, certex2));
        CryptographerTest.assertNotNull((Object)decryEntity);
        byte[] decryEntityBytes = EntitySerializer.Default.serializeToBytes((MimePart)decryEntity);
        byte[] entityBytes = EntitySerializer.Default.serializeToBytes((MimePart)entity);
        CryptographerTest.assertTrue((boolean)Arrays.equals(decryEntityBytes, entityBytes));
    }

    public void testvalidateSignature() throws Exception {
        String str = FileUtils.readFileToString((File)new File("./src/test/resources/org/nhindirect/stagent/msgSig.txt"));
        byte[] byteData = Base64.decode((String)str);
        CMSSignedData signed = new CMSSignedData(byteData);
        Store certs = signed.getCertificates();
        for (X509CertificateHolder cert : certs.getMatches(null)) {
            FileUtils.writeByteArrayToFile((File)new File("./testCert.der"), (byte[])cert.getEncoded());
        }
    }
}

